/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.RectOverlapCalc;
import com.harrand.sketch.linkStrategies.positioner.ILinkPositioner;
import com.harrand.sketch.linkStrategies.right_angle.calc.NamePositionCoordSetter;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.OneLineUserLinkPositioner;
import com.harrand.sketch.linkStrategies.rollover.ISingleLinkLinePossible;
import com.harrand.sketch.relation.edge.IEdgeTrackable;
import com.harrand.sketch.relation.line.LineRole;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.rect.LinkRect;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public final class RectOverlapAutoPositioner
implements ILinkPositioner {
    private BoxLink boxLink;
    private Rectangle2D boxA_;
    private Rectangle2D boxB_;
    private final RectOverlapCalc rectOverlapCalc = new RectOverlapCalc();
    public static final int MINIMUM_OVERLAP = 8;

    @Override
    public void updateShapePositions(BoxLink boxLink) {
        this.boxLink = boxLink;
        this.initFields();
        this.rectOverlapCalc.doCalcs(this.boxA_, this.boxB_, 8);
        PositionableLine line = null;
        Point2D endPointA = this.rectOverlapCalc.getJointPtA();
        Point2D endPointB = this.rectOverlapCalc.getJointPtB();
        LinkRect parentRect = boxLink.getBox("Parent");
        line = new PositionableLine(endPointA, endPointB, parentRect, LineRole.SINGLE_LINE);
        this.rectOverlapCalc.doCalcs(this.boxA_, this.boxB_, 8);
        ((IEdgeTrackable)((Object)boxLink)).setParentEdge(this.rectOverlapCalc.getEdgeA());
        ((IEdgeTrackable)((Object)boxLink)).setChildEdge(this.rectOverlapCalc.getEdgeB());
        this.updateJoints(line);
        ArrayList<PositionableLine> shapes = new ArrayList<PositionableLine>();
        shapes.add(line);
        new NamePositionCoordSetter().setNmPos(boxLink, line);
        ((ISingleLinkLinePossible)((Object)boxLink)).setSingleLinkLinePossible(true);
        boxLink.setShapes(shapes);
        boxLink.setLinkPositioner(new OneLineUserLinkPositioner());
    }

    private void updateJoints(PositionableLine positionableLine) {
        this.boxLink.moveJoint(this.getParentJointName(), this.rectOverlapCalc.getJointPtA());
        this.boxLink.rotateJoint(this.getParentJointName(), this.rectOverlapCalc.getJointAngleA());
        this.boxLink.moveJoint(this.getChildJointName(), this.rectOverlapCalc.getJointPtB());
        this.boxLink.rotateJoint(this.getChildJointName(), this.rectOverlapCalc.getJointAngleB());
    }

    private void initFields() {
        this.boxA_ = this.boxLink.getBox("Parent");
        this.boxB_ = this.boxLink.getBox("Child");
    }

    private String getParentJointName() {
        return this.boxLink.getParentJointName();
    }

    private String getChildJointName() {
        return this.boxLink.getChildJointName();
    }
}

