/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkBoxPair;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.initializer.ILinkPositionInitializer;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.initializer.OneLineLinkPositionerInitializer;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.initializer.ThreeLineLinkPositionInitializer;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.initializer.TwoLineLinkPositionInitializer;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.JointSocket;
import com.harrand.util.LogUtil;

public final class LinkAutoLayoutInfo {
    private BoxLink boxLink;
    private LinkBoxPair linkBoxPair;

    public LinkBoxPair getLinkBoxPair() {
        return this.linkBoxPair;
    }

    public void setLinkBoxPair(LinkBoxPair linkBoxPair) {
        this.linkBoxPair = linkBoxPair;
    }

    public JointSocket getChildJointSocket() {
        return this.linkBoxPair.getChildSocket();
    }

    public ILinkPositionInitializer getLinkPositionInitializer() {
        int linkLineCount = this.linkBoxPair.getLinkLineCount();
        switch (linkLineCount) {
            case 3: {
                return new ThreeLineLinkPositionInitializer();
            }
            case 2: {
                return new TwoLineLinkPositionInitializer();
            }
            case 1: {
                return new OneLineLinkPositionerInitializer();
            }
        }
        LogUtil.logErr(this.getClass().getSimpleName() + " could not match link line count for : " + linkLineCount);
        return null;
    }

    public JointSocket getParentJointSocket() {
        return this.linkBoxPair.getParentSocket();
    }

    public BoxLink getBoxLink() {
        return this.boxLink;
    }

    public void setBoxLink(BoxLink boxLink) {
        this.boxLink = boxLink;
    }
}

