/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.calc.move;

import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.Link;
import java.util.ArrayList;
import java.util.List;

public final class LinksReshapedByGlyphMoveCalc {
    public List<Link> getReshapedLinks(Diagram diagram, List<Glyph> movedGlyphs) {
        ArrayList<Link> affectedLinks = new ArrayList<Link>();
        List<DbTableGlyph> dbTableGlyphs = this.getDbTableGlyphs(movedGlyphs);
        List<String> movedTableNames = this.getMovedTableNames(dbTableGlyphs);
        List<Glyph> linkGlyphs = diagram.getLinkGlyphs();
        for (Glyph linkGlyph : linkGlyphs) {
            String parentTableName;
            if (!(linkGlyph instanceof ForeignKeyGlyph)) continue;
            ForeignKeyGlyph fkGlyph = (ForeignKeyGlyph)linkGlyph;
            ForeignKey fk = fkGlyph.getForeignKey();
            int fkTablesMovedCount = 0;
            String childTableName = fk.getChdTbl().getName();
            if (movedTableNames.contains(childTableName)) {
                ++fkTablesMovedCount;
            }
            if (movedTableNames.contains(parentTableName = fk.getParTbl().getName())) {
                ++fkTablesMovedCount;
            }
            if (fkTablesMovedCount != 1) continue;
            affectedLinks.add(fkGlyph);
        }
        return affectedLinks;
    }

    private List<DbTableGlyph> getDbTableGlyphs(List<Glyph> glyphs) {
        ArrayList<DbTableGlyph> dbTableGlyphs = new ArrayList<DbTableGlyph>();
        for (Glyph glyph : glyphs) {
            if (!(glyph instanceof DbTableGlyph)) continue;
            DbTableGlyph dbTableGlyph = (DbTableGlyph)glyph;
            dbTableGlyphs.add(dbTableGlyph);
        }
        return dbTableGlyphs;
    }

    private List<String> getMovedTableNames(List<DbTableGlyph> dbTableGlyphs) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (DbTableGlyph dbTableGlyph : dbTableGlyphs) {
            String tableName = dbTableGlyph.getTableName();
            tableNames.add(tableName);
        }
        return tableNames;
    }
}

