/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.calc.intersect;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.right_angle.calc.intersect.EdgeTransitionIntersectCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.LinkLineExtractor;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.TwoLineIntersectCalc;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.rect.LinkRect;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.List;

public final class TransitionToThreeLinesIntersectCalc {
    private final EdgeTransitionIntersectCalc transitionIntersectCalc = new EdgeTransitionIntersectCalc();
    private final TwoLineIntersectCalc twoLineIntersectCalc = new TwoLineIntersectCalc();
    private PositionableLine parentLine;
    private PositionableLine childLine;
    private BoxLink boxLink;

    public Point2D[] calcParentAndChildIntersects(BoxLink boxLink, LinkRect transitionedBox, Edge oldEdge, Edge newEdge) {
        this.boxLink = boxLink;
        this.extractLines();
        Point2D transitionIntersect = this.transitionIntersectCalc.getIntersect(transitionedBox, oldEdge, newEdge);
        Line2D partialMiddleLine = this.getPartialMiddleLine(transitionIntersect, oldEdge, newEdge);
        Point2D parentIntersect = null;
        Point2D childIntersect = null;
        if (transitionedBox.isParent()) {
            Point2D otherIntersect = this.twoLineIntersectCalc.getIntersect(this.childLine, partialMiddleLine);
            parentIntersect = transitionIntersect;
            childIntersect = otherIntersect;
        } else {
            Point2D otherIntersect;
            parentIntersect = otherIntersect = this.twoLineIntersectCalc.getIntersect(this.parentLine, partialMiddleLine);
            childIntersect = transitionIntersect;
        }
        return new Point2D[]{parentIntersect, childIntersect};
    }

    private Line2D getPartialMiddleLine(Point2D transitionIntersect, Edge oldEdge, Edge newEdge) {
        Point2D middleLinePartialEndPoint = null;
        middleLinePartialEndPoint = Edge.NORTH.equals((Object)newEdge) || Edge.SOUTH.equals((Object)newEdge) ? this.getEastOrWestMiddleLinePartialEndPoint(transitionIntersect, oldEdge) : this.getNorthOrSouthMiddleLinePartialEndPoint(transitionIntersect, oldEdge);
        return new Line2D.Double(middleLinePartialEndPoint, transitionIntersect);
    }

    private Point2D getEastOrWestMiddleLinePartialEndPoint(Point2D transitionIntersect, Edge oldEdge) {
        int addition = Edge.EAST.equals((Object)oldEdge) ? -10 : 10;
        return new Point2D.Double(transitionIntersect.getX() + (double)addition, transitionIntersect.getY());
    }

    private Point2D getNorthOrSouthMiddleLinePartialEndPoint(Point2D transitionIntersect, Edge oldEdge) {
        int addition = Edge.NORTH.equals((Object)oldEdge) ? -10 : 10;
        return new Point2D.Double(transitionIntersect.getX(), transitionIntersect.getY() + (double)addition);
    }

    private void extractLines() {
        LinkLineExtractor extractor = new LinkLineExtractor();
        List<PositionableLine> lines = extractor.getPositionableLines(this.boxLink);
        this.parentLine = lines.get(0);
        this.childLine = lines.get(1);
    }
}

