/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.calc.intersect;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.LinkLineExtractor;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.edge.IEdgeTrackable;
import com.harrand.sketch.relation.line.PositionableLine;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public final class ThreeLineRelativeIntersectCalc {
    private BoxLink boxLink;
    private Rectangle2D parentBox;
    private Rectangle2D childBox;
    private PositionableLine parentLine;
    private PositionableLine middleLine;
    private PositionableLine childLine;

    public Point2D[] calcParentAndChildIntersects(BoxLink boxLink) {
        this.boxLink = boxLink;
        this.initBoxes();
        this.extractLines();
        Point2D parentIntersect = this.getParentIntersect();
        Point2D childIntersect = this.getChildIntersect();
        return new Point2D[]{parentIntersect, childIntersect};
    }

    private double getIntersectY(Rectangle2D box, PositionableLine line) {
        return box.getY() + line.getRelY();
    }

    private double getIntersectX(Rectangle2D box, PositionableLine line) {
        return box.getX() + line.getRelX();
    }

    private void initBoxes() {
        this.parentBox = this.boxLink.getBox(this.boxLink.getParentBoxName());
        this.childBox = this.boxLink.getBox(this.boxLink.getChildBoxName());
    }

    private void extractLines() {
        LinkLineExtractor extractor = new LinkLineExtractor();
        List<PositionableLine> lines = extractor.getPositionableLines(this.boxLink);
        this.parentLine = lines.get(0);
        this.childLine = lines.get(1);
        this.middleLine = lines.get(2);
    }

    private Point2D getParentIntersect() {
        Edge parentEdge = ((IEdgeTrackable)((Object)this.boxLink)).getParentEdge();
        double x = 0.0;
        double y = 0.0;
        if (Edge.NORTH.equals((Object)parentEdge) || Edge.SOUTH.equals((Object)parentEdge)) {
            x = this.getIntersectX(this.parentBox, this.parentLine);
            y = this.getIntersectY(this.childBox, this.middleLine);
        }
        if (Edge.EAST.equals((Object)parentEdge) || Edge.WEST.equals((Object)parentEdge)) {
            x = this.getIntersectX(this.childBox, this.middleLine);
            y = this.getIntersectY(this.parentBox, this.parentLine);
        }
        return new Point2D.Double(x, y);
    }

    private Point2D getChildIntersect() {
        Edge childEdge = ((IEdgeTrackable)((Object)this.boxLink)).getChildEdge();
        double x = 0.0;
        double y = 0.0;
        if (Edge.NORTH.equals((Object)childEdge) || Edge.SOUTH.equals((Object)childEdge)) {
            x = this.getIntersectX(this.childBox, this.childLine);
            y = this.getIntersectY(this.childBox, this.middleLine);
        }
        if (Edge.EAST.equals((Object)childEdge) || Edge.WEST.equals((Object)childEdge)) {
            x = this.getIntersectX(this.childBox, this.middleLine);
            y = this.getIntersectY(this.childBox, this.childLine);
        }
        return new Point2D.Double(x, y);
    }
}

