/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.calc.intersect;

import com.harrand.sketch.relation.edge.Edge;
import com.harrand.util.LogUtil;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class EdgeTransitionIntersectCalc {
    private static final int EDGE_OFFSET_LENGTH = 5;
    private Rectangle2D box;
    private Edge oldEdge;
    private Edge newEdge;
    private double x;
    private double y;
    private boolean isLesserEnd;

    public Point2D getIntersect(Rectangle2D box, Edge oldEdge, Edge newEdge) {
        this.box = box;
        this.oldEdge = oldEdge;
        this.newEdge = newEdge;
        this.doCalcs();
        Point2D.Double intersect = new Point2D.Double(this.x, this.y);
        return intersect;
    }

    private void doCalcs() {
        switch (this.oldEdge) {
            case NORTH: {
                this.isLesserEnd = true;
                this.setNewEdgeEastOrWestCoords();
                break;
            }
            case SOUTH: {
                this.isLesserEnd = false;
                this.setNewEdgeEastOrWestCoords();
                break;
            }
            case EAST: {
                this.isLesserEnd = false;
                this.setNewEdgeNorthOrSouthCoords();
                break;
            }
            case WEST: {
                this.isLesserEnd = true;
                this.setNewEdgeNorthOrSouthCoords();
            }
        }
    }

    private void setNewEdgeEastOrWestCoords() {
        double d = this.y = this.isLesserEnd ? this.box.getMinY() + this.getEdgeOffsetLength() : this.box.getMaxY() - this.getEdgeOffsetLength();
        if (this.isNewEdgeWest()) {
            this.x = this.getNewWestX();
        } else if (this.isNewEdgeEast()) {
            this.x = this.getNewEastX();
        } else {
            this.logUnknownEdgePair();
        }
    }

    private void setNewEdgeNorthOrSouthCoords() {
        double d = this.x = this.isLesserEnd ? this.box.getMinX() + this.getEdgeOffsetLength() : this.box.getMaxX() - this.getEdgeOffsetLength();
        if (this.isNewEdgeNorth()) {
            this.y = this.getNewNorthY();
        } else if (this.isNewEdgeSouth()) {
            this.y = this.getNewSouthY();
        } else {
            this.logUnknownEdgePair();
        }
    }

    private double getEdgeOffsetLength() {
        return 5.0;
    }

    private double getNewEastX() {
        return this.box.getMaxX() + this.getEdgeOffsetLength();
    }

    private double getNewWestX() {
        return this.box.getMinX() - this.getEdgeOffsetLength();
    }

    private double getNewNorthY() {
        return this.box.getMinY() - this.getEdgeOffsetLength();
    }

    private double getNewSouthY() {
        return this.box.getMaxY() + this.getEdgeOffsetLength();
    }

    private void logUnknownEdgePair() {
        LogUtil.logMsg("OneToTwoLineTransitioner.unknown.edge.pair: " + (Object)((Object)this.newEdge) + ", " + (Object)((Object)this.oldEdge));
    }

    private boolean isNewEdgeWest() {
        return Edge.WEST.equals((Object)this.newEdge);
    }

    private boolean isNewEdgeEast() {
        return Edge.EAST.equals((Object)this.newEdge);
    }

    private boolean isNewEdgeNorth() {
        return Edge.NORTH.equals((Object)this.newEdge);
    }

    private boolean isNewEdgeSouth() {
        return Edge.SOUTH.equals((Object)this.newEdge);
    }
}

