/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.calc;

import java.awt.geom.Rectangle2D;

public final class SingleLinkLineZoneCalc {
    private Rectangle2D boxA;
    private Rectangle2D boxB;
    private Rectangle2D zone;
    private boolean overlapFound = false;
    private double aMinX;
    private double aMaxX;
    private double bMinX;
    private double bMaxX;
    private double aMinY;
    private double aMaxY;
    private double bMinY;
    private double bMaxY;
    private double zoneMinX;
    private double zoneMaxX;
    private double zoneMinY;
    private double zoneMaxY;

    public Rectangle2D getSingleLineZone(Rectangle2D boxA, Rectangle2D boxB) {
        this.reset();
        this.boxA = boxA;
        this.boxB = boxB;
        this.loadValues();
        this.calcZoneDimensions();
        return this.zone;
    }

    public boolean getSingleLineZoneExists(Rectangle2D boxA, Rectangle2D boxB) {
        Rectangle2D singleLineZone = this.getSingleLineZone(boxA, boxB);
        return singleLineZone != null;
    }

    private void loadValues() {
        this.aMinX = this.boxA.getMinX();
        this.aMaxX = this.boxA.getMaxX();
        this.bMinX = this.boxB.getMinX();
        this.bMaxX = this.boxB.getMaxX();
        this.aMinY = this.boxA.getMinY();
        this.aMaxY = this.boxA.getMaxY();
        this.bMinY = this.boxB.getMinY();
        this.bMaxY = this.boxB.getMaxY();
    }

    private void reset() {
        this.overlapFound = false;
        this.zone = null;
        this.zoneMinX = 0.0;
        this.zoneMaxX = 0.0;
        this.zoneMinY = 0.0;
        this.zoneMaxY = 0.0;
    }

    private void calcZoneDimensions() {
        this.calcOverlapX();
        if (!this.overlapFound) {
            this.calcOverlapY();
        }
    }

    private void calcOverlapX() {
        if (this.isInBetween(this.aMinX, this.bMinX, this.bMaxX)) {
            this.calcZoneValuesForXOverlap(this.aMinX);
            return;
        }
        if (this.isInBetween(this.bMinX, this.aMinX, this.aMaxX)) {
            this.calcZoneValuesForXOverlap(this.bMinX);
            return;
        }
        if (this.overlapFound) {
            this.zoneMaxX = Math.min(this.aMaxX, this.bMaxX);
        }
    }

    private void calcOverlapY() {
        if (this.isInBetween(this.aMinY, this.bMinY, this.bMaxY)) {
            this.calcZoneValuesForYOverlap(this.aMinY);
            return;
        }
        if (this.isInBetween(this.bMinY, this.aMinY, this.aMaxY)) {
            this.calcZoneValuesForYOverlap(this.bMinY);
            return;
        }
        if (this.overlapFound) {
            this.zoneMaxY = Math.min(this.aMaxY, this.bMaxY);
        }
    }

    private boolean isInBetween(double value, double min, double max) {
        return value >= min && value <= max;
    }

    private void calcZoneValuesForXOverlap(double zoneMinX) {
        this.zoneMinX = zoneMinX;
        this.zoneMaxX = Math.min(this.aMaxX, this.bMaxX);
        if (this.aMinY < this.bMinY) {
            this.zoneMinY = this.aMaxY;
            this.zoneMaxY = this.bMinY;
        } else {
            this.zoneMinY = this.bMaxY;
            this.zoneMaxY = this.aMinY;
        }
        this.overlapFound = true;
        this.buildZoneRectangle();
    }

    private void calcZoneValuesForYOverlap(double zoneMinY) {
        this.zoneMinY = zoneMinY;
        this.zoneMaxY = Math.min(this.aMaxY, this.bMaxY);
        if (this.aMinY < this.bMinY) {
            zoneMinY = this.aMaxY;
            this.zoneMaxY = this.bMinY;
        } else {
            zoneMinY = this.bMaxY;
            this.zoneMaxY = this.aMinY;
        }
        this.overlapFound = true;
        this.buildZoneRectangle();
    }

    private void buildZoneRectangle() {
        this.zone = new Rectangle2D.Double(this.zoneMinX, this.zoneMinY, this.zoneMaxX, this.zoneMaxY);
    }
}

