/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.calc;

import com.harrand.sketch.relation.edge.Edge;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class ProjectedLinePointCalc {
    private Edge oldEdge;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    public Point2D getProjectedLinePoint(Rectangle2D box, Edge oldEdge, Edge newEdge) {
        this.oldEdge = oldEdge;
        this.minX = box.getMinX();
        this.maxX = box.getMaxX();
        this.minY = box.getMinY();
        this.maxY = box.getMaxY();
        switch (newEdge) {
            case NORTH: {
                return this.getNorthEdgePoint();
            }
            case SOUTH: {
                return this.getSouthProjected();
            }
            case WEST: {
                return this.getWestProjected();
            }
            case EAST: {
                return this.getEastProjected();
            }
        }
        return null;
    }

    private Point2D getNorthEdgePoint() {
        double y = this.minY - 1.0;
        switch (this.oldEdge) {
            case WEST: {
                return this.getPoint(this.minX + 1.0, y);
            }
            case EAST: {
                return this.getPoint(this.maxX - 1.0, y);
            }
        }
        return null;
    }

    private Point2D getSouthProjected() {
        double y = this.maxY + 1.0;
        switch (this.oldEdge) {
            case WEST: {
                return this.getPoint(this.minX + 1.0, y);
            }
            case EAST: {
                return this.getPoint(this.maxX - 1.0, y);
            }
        }
        return null;
    }

    private Point2D getWestProjected() {
        double x = this.minX - 1.0;
        switch (this.oldEdge) {
            case NORTH: {
                return this.getPoint(x, this.minY + 1.0);
            }
            case SOUTH: {
                return this.getPoint(x, this.maxY - 1.0);
            }
        }
        return null;
    }

    private Point2D getEastProjected() {
        double x = this.maxX + 1.0;
        switch (this.oldEdge) {
            case NORTH: {
                return this.getPoint(x, this.minY + 1.0);
            }
            case SOUTH: {
                return this.getPoint(x, this.maxY - 1.0);
            }
        }
        return null;
    }

    private Point2D getPoint(double x, double y) {
        return new Point2D.Double(x, y);
    }
}

