/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle;

import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.diagram.table.DbTableGlyphLinkBoxesBldr;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.linkStrategies.SelfJoinCalc;
import com.harrand.sketch.linkStrategies.positioner.ILinkPositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.LinkAutoPositionInitializer;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkBoxPair;
import java.util.ArrayList;

public class RightAngleLinkUpdater {
    private Link link;
    private SelfJoinCalc selfJoinCalc_ = new SelfJoinCalc();
    private int edgeA_;
    private int edgeB_;
    private double angleA_;
    private double angleB_;
    private boolean useFollowerPos_;
    public static final int MINIMUM_OVERLAP = 8;
    public static final int CLOSE_ANGLE = 45;
    private Diagram diagram;

    public void updateLink(Link link) {
        this.link = link;
        if (link.getIsSelfJoin()) {
            this.selfJoinCalc_.updateLink(link);
        } else {
            this.refresh();
        }
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    public Link getLink() {
        return this.link;
    }

    private void refresh() {
        if (this.link.getLinkPositioner() != null) {
            this.doUserLayout();
        } else if (this.link instanceof ForeignKeyGlyph && this.diagram != null) {
            ForeignKeyGlyph fkGlyph = (ForeignKeyGlyph)this.link;
            ForeignKey fk = fkGlyph.getFk();
            ArrayList<LinkBoxPair> linkBoxPairs = new ArrayList<LinkBoxPair>();
            LinkBoxPair linkBoxPair = new DbTableGlyphLinkBoxesBldr().createLinkBoxPair(this.link, fk, this.diagram);
            linkBoxPairs.add(linkBoxPair);
            new LinkAutoPositionInitializer().initializeLinkPositions(linkBoxPairs);
        }
    }

    private void doUserLayout() {
        ILinkPositioner linkPositioner = this.link.getLinkPositioner();
        linkPositioner.updateShapePositions(this.link);
    }

    public int getEdgeA() {
        return this.edgeA_;
    }

    public int getEdgeB() {
        return this.edgeB_;
    }

    public boolean getUseFollowerPos() {
        return this.useFollowerPos_;
    }

    public double getAngleA() {
        return this.angleA_;
    }

    public double getAngleB() {
        return this.angleB_;
    }
}

