/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.arc;

import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.linkStrategies.arc.ArcQuadrant;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.util.LogUtil;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public final class LineBasedArcBuilder {
    private Edge horizontalEdge;
    private Edge verticalEdge;
    private Line2D horizontalLine;
    private Line2D verticalLine;
    private Point2D ptStartCCW;
    private Point2D ptEndCCW;
    private ArcQuadrant quadrant;
    private Line2D lineB;
    private Line2D lineA;
    private int arcRadius = 3;

    public Arc2D getArc(Line2D lineA, Line2D lineB) {
        this.lineA = lineA;
        this.lineB = lineB;
        this.processLine(lineA, lineB);
        this.processLine(lineB, lineA);
        if (this.horizontalEdge == null || this.verticalEdge == null) {
            return null;
        }
        this.calcPoints();
        this.quadrant = this.getCCWArcQuadrant();
        int startAngle = this.quadrant.getStartAngle();
        Point2D arcOrigin = this.getArcOrigin();
        double x = arcOrigin.getX();
        double y = arcOrigin.getY();
        Arc2D.Double arc = new Arc2D.Double(x, y, 6.0, 6.0, startAngle, 90.0, 0);
        return arc;
    }

    public int getArcRadius() {
        return this.arcRadius;
    }

    private void processLine(Line2D line, Line2D otherLine) {
        boolean isHorizontal;
        boolean isVertical = GeometryHelper.isLineVertical(line);
        if (isVertical) {
            this.verticalLine = line;
            this.verticalEdge = line.getY1() <= otherLine.getY1() ? Edge.SOUTH : Edge.NORTH;
        }
        if (isHorizontal = GeometryHelper.isLineHorizontal(line)) {
            this.horizontalLine = line;
            this.horizontalEdge = line.getX1() <= otherLine.getX1() ? Edge.EAST : Edge.WEST;
        }
    }

    private void calcPoints() {
        if (Edge.NORTH.equals((Object)this.verticalEdge)) {
            if (Edge.WEST.equals((Object)this.horizontalEdge)) {
                this.ptStartCCW = this.horizontalLine.getP2();
                this.ptEndCCW = this.verticalLine.getP2();
            }
            if (Edge.EAST.equals((Object)this.horizontalEdge)) {
                this.ptStartCCW = this.verticalLine.getP2();
                this.ptEndCCW = this.horizontalLine.getP2();
            }
        }
        if (Edge.SOUTH.equals((Object)this.verticalEdge)) {
            if (Edge.WEST.equals((Object)this.horizontalEdge)) {
                this.ptStartCCW = this.verticalLine.getP2();
                this.ptEndCCW = this.horizontalLine.getP2();
            }
            if (Edge.EAST.equals((Object)this.horizontalEdge)) {
                this.ptStartCCW = this.horizontalLine.getP2();
                this.ptEndCCW = this.verticalLine.getP2();
            }
        }
        if (this.ptEndCCW == null || this.ptEndCCW == null) {
            System.out.println("LineBasedArcBuilder.fallthrough");
        }
    }

    private ArcQuadrant getCCWArcQuadrant() {
        if (this.ptStartCCW == null) {
            LogUtil.logErr(this, "Pt should not be null");
        }
        if (this.ptEndCCW == null) {
            LogUtil.logErr(this, "Pt should not be null");
        }
        double aX = this.ptStartCCW.getX();
        double aY = this.ptStartCCW.getY();
        double bX = this.ptEndCCW.getX();
        double bY = this.ptEndCCW.getY();
        if (aY <= bY) {
            if (aX <= bX) {
                return ArcQuadrant.QUAD_3;
            }
            return ArcQuadrant.QUAD_2;
        }
        if (aX <= bX) {
            return ArcQuadrant.QUAD_4;
        }
        return ArcQuadrant.QUAD_1;
    }

    private Point2D getArcOrigin() {
        double d = 2 * this.arcRadius;
        switch (this.quadrant) {
            case QUAD_1: {
                return new Point2D.Double(this.ptStartCCW.getX() - (double)(2 * this.arcRadius), this.ptStartCCW.getY() - (double)this.arcRadius - 1.0);
            }
            case QUAD_2: {
                return new Point2D.Double(this.ptStartCCW.getX() - (double)this.arcRadius - 1.0, this.ptStartCCW.getY());
            }
            case QUAD_3: {
                return new Point2D.Double(this.ptStartCCW.getX(), this.ptStartCCW.getY() - (double)this.arcRadius + 1.0);
            }
            case QUAD_4: {
                return new Point2D.Double(this.ptStartCCW.getX() - (double)this.arcRadius + 1.0, this.ptStartCCW.getY() - d);
            }
        }
        return null;
    }

    private boolean areLinesTooShort() {
        return this.isLineTooShort(this.lineA) || this.isLineTooShort(this.lineA);
    }

    private boolean isLineTooShort(Line2D line) {
        double lineLength = line.getP1().distance(line.getP2());
        return lineLength < 3.0;
    }

    private void computeArcRadius() {
        this.arcRadius = 3;
        this.checkReduceArcRadius(this.lineA);
        this.checkReduceArcRadius(this.lineB);
        LogUtil.logMsg(this, "arcRadius: " + this.arcRadius);
    }

    private void checkReduceArcRadius(Line2D line) {
        double lineLength = line.getP1().distance(line.getP2());
        if (lineLength < 3.0) {
            this.arcRadius = (int)lineLength;
        }
    }
}

