/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies;

import com.harrand.coreclasses.geometry.positioningCoord.IPositioningCoord;
import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.core.IJoint;
import com.harrand.sketch.linkStrategies.linkNm.OffsetDirectNmPositionCalc;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class SelfJoinCalc {
    private BoxLink boxLink_;
    private int edgeA_;
    private int edgeB_;
    private double angleA_;
    private double angleB_;
    private Rectangle2D boxA_;
    public final int FROM_EDGE = 15;
    public final int NORTH_EDGE = 0;
    public final int EAST_EDGE = 1;
    public final int SOUTH_EDGE = 2;
    public final int WEST_EDGE = 3;

    public void updateLink(BoxLink boxLink) {
        this.boxLink_ = boxLink;
        this.refresh();
    }

    public BoxLink getBoxLink() {
        return this.boxLink_;
    }

    public int getEdgeA() {
        return this.edgeA_;
    }

    public int getEdgeB() {
        return this.edgeB_;
    }

    public double getAngleA() {
        return this.angleA_;
    }

    public double getAngleB() {
        return this.angleB_;
    }

    private void refresh() {
        this.boxA_ = this.boxLink_.getBox("Parent");
        this.calcEdgesToUse();
        this.updateJoints();
        ArrayList lines = new ArrayList();
        lines.addAll(this.getConnectionLines());
        this.boxLink_.setShapes(lines);
    }

    private void calcEdgesToUse() {
        this.edgeA_ = 3;
        this.edgeB_ = 0;
    }

    private void updateJoints() {
        Point2D.Double jointStartB = new Point2D.Double((int)this.boxA_.getX() + 15, (int)this.boxA_.getY());
        this.boxLink_.moveJoint(this.boxLink_.getChildJointName(), jointStartB);
        this.boxLink_.rotateJoint(this.boxLink_.getChildJointName(), 90.0);
        Point2D.Double jointStartA = new Point2D.Double((int)this.boxA_.getX(), (int)this.boxA_.getY() + 15);
        this.boxLink_.moveJoint(this.boxLink_.getParentJointName(), jointStartA);
        this.boxLink_.rotateJoint(this.boxLink_.getParentJointName(), 180.0);
    }

    private List getConnectionLines() {
        IJoint jointA = this.boxLink_.getJoint(this.boxLink_.getParentJointName());
        IJoint jointB = this.boxLink_.getJoint(this.boxLink_.getChildJointName());
        Point2D jointAEnd = jointA.getEndPoint();
        Point2D jointBEnd = jointB.getEndPoint();
        double AX = jointAEnd.getX();
        double BY = jointBEnd.getY();
        Point2D.Double cornerPt = new Point2D.Double(AX, BY);
        ArrayList<Line2D.Double> lines = new ArrayList<Line2D.Double>();
        Line2D.Double vertLine = new Line2D.Double(jointAEnd, cornerPt);
        Line2D.Double horzLine = new Line2D.Double(cornerPt, jointBEnd);
        lines.add(vertLine);
        lines.add(horzLine);
        this.setNmPos(vertLine);
        return lines;
    }

    private void setNmPos(Line2D connectingLine) {
        OffsetDirectNmPositionCalc nmPosCalc = new OffsetDirectNmPositionCalc();
        IPositioningCoord nmPosCoord = nmPosCalc.getNmCoord(connectingLine, "ShiftLeft", true);
        this.boxLink_.setNmPosCoord(nmPosCoord);
    }
}

