/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies;

import com.harrand.sketch.linkStrategies.joint.JointAngleCalc;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.util.LogUtil;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class RectOverlapCalc {
    private Rectangle2D boxA_;
    private Rectangle2D boxB_;
    private Point2D jointPtA_;
    private Point2D jointPtB_;
    private boolean hasOverlap_ = false;
    private int minOverlapRequired_;
    private int overlapMidCoord_;
    private Edge edgeA_;
    private Edge edgeB_;
    private int angleA_;
    private int angleB_;

    public RectOverlapCalc() {
        this.reset();
    }

    public boolean doCalcs(Rectangle2D boxA, Rectangle2D boxB) {
        return this.doCalcs(boxA, boxB, 8);
    }

    public boolean doCalcs(Rectangle2D boxA, Rectangle2D boxB, int minOverlapRequired) {
        this.reset();
        this.boxA_ = boxA;
        this.boxB_ = boxB;
        this.minOverlapRequired_ = minOverlapRequired;
        this.calcOverlapDisp();
        return this.getHasOverlap();
    }

    public Edge getEdgeA() {
        return this.edgeA_;
    }

    public Edge getEdgeB() {
        return this.edgeB_;
    }

    public Point2D getJointPtA() {
        return this.jointPtA_;
    }

    public Point2D getJointPtB() {
        return this.jointPtB_;
    }

    public int getJointAngleA() {
        return this.angleA_;
    }

    public int getJointAngleB() {
        return this.angleB_;
    }

    public boolean getHasOverlap() {
        return this.hasOverlap_;
    }

    private void reset() {
        this.minOverlapRequired_ = -1;
        this.hasOverlap_ = false;
        this.edgeA_ = null;
        this.edgeB_ = null;
        this.jointPtA_ = null;
        this.jointPtB_ = null;
    }

    private void calcOverlapDisp() {
        if (this.boxA_.getWidth() > this.boxB_.getWidth()) {
            this.calcOverlap(this.boxB_.getMinX(), this.boxB_.getMaxX(), this.boxA_.getMinX(), this.boxA_.getMaxX());
        } else {
            this.calcOverlap(this.boxA_.getMinX(), this.boxA_.getMaxX(), this.boxB_.getMinX(), this.boxB_.getMaxX());
        }
        if (this.hasOverlap_) {
            if (this.boxA_.getY() < this.boxB_.getY()) {
                this.edgeA_ = Edge.SOUTH;
                this.edgeB_ = Edge.NORTH;
            } else {
                this.edgeA_ = Edge.NORTH;
                this.edgeB_ = Edge.SOUTH;
            }
        } else {
            if (this.boxA_.getHeight() > this.boxB_.getHeight()) {
                this.calcOverlap(this.boxB_.getMinY(), this.boxB_.getMaxY(), this.boxA_.getMinY(), this.boxA_.getMaxY());
            } else {
                this.calcOverlap(this.boxA_.getMinY(), this.boxA_.getMaxY(), this.boxB_.getMinY(), this.boxB_.getMaxY());
            }
            if (this.hasOverlap_) {
                if (this.boxA_.getX() < this.boxB_.getX()) {
                    this.edgeA_ = Edge.EAST;
                    this.edgeB_ = Edge.WEST;
                } else {
                    this.edgeA_ = Edge.WEST;
                    this.edgeB_ = Edge.EAST;
                }
            }
        }
        if (this.hasOverlap_) {
            this.jointPtA_ = this.getJointPos(this.boxA_, this.edgeA_);
            this.jointPtB_ = this.getJointPos(this.boxB_, this.edgeB_);
            this.angleA_ = JointAngleCalc.getJointAngle(this.edgeA_);
            this.angleB_ = JointAngleCalc.getJointAngle(this.edgeB_);
        }
    }

    private void calcOverlap(double smallMin, double smallMax, double largeMin, double largeMax) {
        double overlap = 0.0;
        double overlapMidCoordDouble = 0.0;
        if (smallMax <= largeMin) {
            overlap = 0.0;
        } else if (smallMin >= largeMax) {
            overlap = 0.0;
        } else if (smallMax >= largeMax) {
            overlap = largeMax - smallMin;
            overlapMidCoordDouble = (largeMax + smallMin) / 2.0;
        } else if (smallMin >= largeMin) {
            overlap = smallMax - smallMin;
            overlapMidCoordDouble = (smallMax + smallMin) / 2.0;
        } else if (largeMin >= smallMin) {
            overlap = smallMax - largeMin;
            overlapMidCoordDouble = (smallMax + largeMin) / 2.0;
        } else {
            LogUtil.logMsg("Unknown condition in calc: " + smallMin + ", " + smallMax + ", " + largeMin + ", " + largeMax);
        }
        this.overlapMidCoord_ = (int)overlapMidCoordDouble;
        if (overlap > (double)this.minOverlapRequired_) {
            this.hasOverlap_ = true;
        }
    }

    private Point2D getJointPos(Rectangle2D box, Edge edge) {
        Point2D.Double jointPt = null;
        switch (edge) {
            case NORTH: {
                jointPt = new Point2D.Double(this.getCalculatedX(), box.getMinY());
                break;
            }
            case SOUTH: {
                jointPt = new Point2D.Double(this.getCalculatedX(), box.getMaxY());
                break;
            }
            case WEST: {
                jointPt = new Point2D.Double(box.getMinX(), this.getCalculatedY());
                break;
            }
            case EAST: {
                jointPt = new Point2D.Double(box.getMaxX(), this.getCalculatedY());
            }
        }
        return jointPt;
    }

    private double getCalculatedX() {
        return this.overlapMidCoord_;
    }

    private double getCalculatedY() {
        return this.overlapMidCoord_;
    }
}

