/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies;

import com.harrand.coreclasses.list.NamedList;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.util.XmlHelper;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class CenterDirect
implements LinkStrategy {
    private NamedList links_;
    public static final String DISPLAY_NM = "Single Line";
    public static final String XML_NM = "CenterDirect";
    public static final int STRATEGY_ID = 0;

    @Override
    public NamedList updateLinks(NamedList links) {
        this.links_ = new NamedList(links);
        for (String linkName : this.links_.getNames()) {
            this.addLines(linkName);
        }
        return new NamedList(this.links_);
    }

    private void addLines(String linkName) {
        Link link = (Link)((Object)this.links_.get(linkName));
        ArrayList<Line2D> lines = new ArrayList<Line2D>();
        lines.add(CenterDirect.getLineWallToWall(link.getBox("Parent"), link.getBox("Child"), CenterDirect.getFormatCentered()));
        link.setShapes(lines);
        this.updateJoints(link, lines);
    }

    private void updateJoints(Link link, List lines) {
        Line2D parentLine = (Line2D)lines.get(0);
        Line2D childLine = lines.size() > 1 ? (Line2D)lines.get(lines.size() - 1) : new Line2D.Double(parentLine.getP2(), parentLine.getP1());
        link.moveJoint(link.getParentJointName(), parentLine.getP1());
        link.moveJoint(link.getChildJointName(), childLine.getP1());
        link.rotateJoint(link.getParentJointName(), GeometryHelper.getAngleJ2D(parentLine.getP1(), parentLine.getP2()));
        link.rotateJoint(link.getChildJointName(), GeometryHelper.getAngleJ2D(childLine.getP1(), childLine.getP2()));
    }

    public static Line2D getLineWallToWall(Rectangle2D rectA, Rectangle2D rectB, int format) {
        Point2D ptA = new Point2D.Double();
        Point2D ptB = new Point2D.Double();
        ArrayList edges = CenterDirect.getEdgesToUse(rectA, rectB);
        int edgeA = (Integer)edges.get(0);
        int edgeB = (Integer)edges.get(1);
        if (format == CenterDirect.getFormatCentered()) {
            ptA = CenterDirect.getJointLocation(rectA, edgeA);
            ptB = CenterDirect.getJointLocation(rectB, edgeB);
        }
        return new Line2D.Double(ptA, ptB);
    }

    private static Line2D getLineCenterToCenter(Rectangle2D rectA, Rectangle2D rectB) {
        return CenterDirect.getCentroidAxis(rectA, rectB);
    }

    public static Point2D getJointLocation(Rectangle2D rect, int edge) {
        double x = rect.getCenterX();
        double y = rect.getCenterY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        if (edge == 1) {
            x += 0.5 * w;
        } else if (edge == 0) {
            y -= 0.5 * h;
        } else if (edge == 3) {
            x -= 0.5 * w;
        } else if (edge == 2) {
            y += 0.5 * h;
        }
        return new Point2D.Double(x, y);
    }

    public static ArrayList getEdgesToUse(Rectangle2D rectA, Rectangle2D rectB) {
        Line2D axis = CenterDirect.getCentroidAxis(rectA, rectB);
        Point2D ptA = axis.getP1();
        Point2D ptB = axis.getP2();
        double radiansA = Math.atan2(-ptB.getY() - -ptA.getY(), ptB.getX() - ptA.getX());
        ArrayList<Integer> edges = new ArrayList<Integer>();
        double degreesA = Math.toDegrees(radiansA);
        double degreesB = degreesA + 180.0;
        edges.add(new Integer(CenterDirect.getAngleEdge(degreesA)));
        edges.add(new Integer(CenterDirect.getAngleEdge(degreesB)));
        return edges;
    }

    @Override
    public boolean getAreLinksMovable() {
        return false;
    }

    public static int getAngleEdge(double degrees) {
        double boundary = 45.0;
        double angle = GeometryHelper.normalizeAngle(GeometryHelper.reduceAngle(degrees));
        if (angle <= boundary || angle >= 360.0 - boundary) {
            return 1;
        }
        if (angle > boundary && angle < 180.0 - boundary) {
            return 0;
        }
        if (angle >= 180.0 - boundary && angle <= 180.0 + boundary) {
            return 3;
        }
        if (angle > 180.0 + boundary && angle <= 360.0 - boundary) {
            return 2;
        }
        return 0;
    }

    public static int getFormatCentered() {
        return 0;
    }

    public static int getFormatSpaced() {
        return 1;
    }

    public static Line2D getCentroidAxis(Rectangle2D rectA, Rectangle2D rectB) {
        return new Line2D.Double(rectA.getCenterX(), rectA.getCenterY(), rectB.getCenterX(), rectB.getCenterY());
    }

    private void rotateEnd(String linkName, String endName, Line2D tail) {
    }

    public void setLinks(TreeMap links) {
    }

    @Override
    public String getName() {
        return XML_NM;
    }

    @Override
    public int getStrategyId() {
        return 0;
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = XmlHelper.createElementSimple(doc, "LinkStrategy", this.getName());
        return element;
    }

    @Override
    public void setDiagram(Diagram diagram) {
    }

    @Override
    public Diagram getDiagram() {
        return null;
    }
}

