/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.layout;

import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BasicDiagramLayoutCtrl {
    private List glyphs_;
    private Point topLeft_;
    private Diagram diagram_;
    private Object[][] grid_;
    private int glyphCount_;
    private int rowCount_;
    private int columnCount_;
    private int[] columnWidths_;
    private int[] rowHeights_;
    private double zoomLevel_;
    public static final int HORZ_GLYPH_GAP = 95;
    public static final int VERT_GLYPH_GAP = 65;

    public BasicDiagramLayoutCtrl(Diagram diagram) {
        this.diagram_ = diagram;
        this.zoomLevel_ = this.diagram_.getZoom().getLevel();
    }

    public Map getGlyphLocations(List glyphs, Point topLeft) {
        Map map = new HashMap();
        if (glyphs.size() > 0) {
            this.glyphs_ = glyphs;
            this.topLeft_ = Zoomer.zoom(topLeft, 1.0 / this.zoomLevel_);
            map = this.calcLocations();
        }
        return map;
    }

    private Map calcLocations() {
        this.zoomLevel_ = this.diagram_.getZoom().getLevel();
        this.initGrid();
        this.loadGrid();
        this.updateGridDimensions();
        return this.getGlyphStarts();
    }

    private void initGrid() {
        int glyphCount_ = this.glyphs_.size();
        switch (glyphCount_) {
            case 1: {
                this.rowCount_ = 1;
                this.columnCount_ = 1;
                break;
            }
            case 2: {
                this.rowCount_ = 1;
                this.columnCount_ = 2;
                break;
            }
            case 4: {
                this.rowCount_ = 2;
                this.columnCount_ = 2;
                break;
            }
            default: {
                int root = (int)Math.sqrt(glyphCount_);
                this.columnCount_ = this.rowCount_ = root + 1;
            }
        }
        this.columnWidths_ = new int[this.columnCount_];
        this.rowHeights_ = new int[this.rowCount_];
        this.grid_ = new Object[this.rowCount_][this.columnCount_];
    }

    private void loadGrid() {
        int row = 0;
        int column = 0;
        for (Glyph glyph : this.glyphs_) {
            this.grid_[row][column] = glyph;
            if (column == this.columnCount_ - 1) {
                column = 0;
                ++row;
                continue;
            }
            ++column;
        }
    }

    private void updateGridDimensions() {
        for (int r = 0; r < this.rowCount_; ++r) {
            for (int c = 0; c < this.columnCount_; ++c) {
                if (!(this.grid_[r][c] instanceof Glyph)) continue;
                Glyph glyph = (Glyph)this.grid_[r][c];
                Rectangle2D bounds = glyph.getBounds2D();
                this.updateRowHeight(bounds, r);
                this.updateColumnWidth(bounds, c);
            }
        }
    }

    private void updateRowHeight(Rectangle2D bounds, int row) {
        int oldHeight = this.rowHeights_[row];
        int height = (int)bounds.getHeight();
        this.rowHeights_[row] = Math.max(height, oldHeight);
    }

    private void updateColumnWidth(Rectangle2D bounds, int column) {
        int oldWidth = this.columnWidths_[column];
        int width = (int)bounds.getWidth();
        this.columnWidths_[column] = Math.max(width, oldWidth);
    }

    private Map getGlyphStarts() {
        HashMap<String, Point> map = new HashMap<String, Point>();
        int currentY = (int)this.topLeft_.getY();
        for (int r = 0; r < this.rowCount_; ++r) {
            int currentX = (int)this.topLeft_.getX();
            for (int c = 0; c < this.columnCount_; ++c) {
                if (this.grid_[r][c] instanceof Glyph) {
                    Glyph glyph = (Glyph)this.grid_[r][c];
                    Point start = new Point(currentX, currentY);
                    map.put(glyph.getName(), start);
                }
                currentX += this.columnWidths_[c] + 95;
            }
            currentY += this.rowHeights_[r] + 65;
        }
        return map;
    }
}

