/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d.draw;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.sketch.j2d.draw.IDrawable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;

public class RoundRectShadow
implements IDrawable {
    private String name;
    private final RoundRectangle2D rect;
    private Zoom lastZoom;
    private List<Shape> shadowLines = new ArrayList<Shape>();
    private List<Shape> shadowArcs = new ArrayList<Shape>();
    private List<Shape> shineShapes = new ArrayList<Shape>();

    public RoundRectShadow(RoundRectangle2D rect, String name) {
        this.setName(name);
        this.rect = rect;
        this.refreshShapes(new Zoom(1.0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean getShineFlag() {
        return true;
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        if (!this.lastZoom.equals(zoom)) {
            this.refreshShapes(zoom);
        }
        Paint oldPaint = g2.getPaint();
        g2.setPaint(Colors.getGrayLight());
        for (Shape shape : this.shadowLines) {
            g2.draw(shape);
        }
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.5f));
        for (Shape shape : this.shadowArcs) {
            g2.draw(shape);
        }
        g2.setStroke(oldStroke);
        g2.setPaint(Color.WHITE);
        for (Shape shape : this.shineShapes) {
            g2.draw(shape);
        }
        g2.setPaint(oldPaint);
    }

    private void refreshShapes(Zoom zoom) {
        this.shadowLines = new ArrayList<Shape>();
        this.shadowArcs = new ArrayList<Shape>();
        RoundRectangle2D drawRect = this.getDrawRect(zoom);
        int size = this.getShadowSize(zoom);
        double r = drawRect.getArcWidth();
        double halfR = 0.5 * r;
        double minX = drawRect.getMinX();
        double maxX = drawRect.getMaxX();
        double minY = drawRect.getMinY();
        double maxY = drawRect.getMaxY();
        for (int i = 1; i <= size; ++i) {
            int startOffset = i - 2;
            int endOffset = i - 1;
            Line2D.Double bottomLine = new Line2D.Double(minX + halfR + (double)startOffset, maxY + (double)i, maxX - halfR + (double)endOffset, maxY + (double)i);
            Line2D.Double rightLine = new Line2D.Double(maxX + (double)i, minY + halfR + (double)startOffset, maxX + (double)i, maxY - halfR + (double)endOffset);
            Arc2D.Double arcBottom = new Arc2D.Double(maxX - r + (double)i, maxY - r + (double)i, r, r, 270.0, 90.0, 0);
            this.shadowLines.add(bottomLine);
            this.shadowLines.add(rightLine);
            this.shadowArcs.add(arcBottom);
        }
        this.shineShapes = new ArrayList<Shape>();
        if (this.getShineFlag()) {
            this.refreshShineShapes(minX, halfR, minY, maxX, maxY, r);
        }
        this.lastZoom = new Zoom(zoom.getLevel());
    }

    private void refreshShineShapes(double minX, double halfR, double minY, double maxX, double maxY, double r) {
        Line2D.Double topLine = new Line2D.Double(minX + halfR + 1.0, minY + 1.0, maxX - halfR + 1.0, minY + 1.0);
        Line2D.Double leftLine = new Line2D.Double(minX + 1.0, minY + halfR + 1.0, minX + 1.0, maxY - halfR + 1.0);
        Arc2D.Double arcTop = new Arc2D.Double(minX + 1.0, minY + 1.0, r, r, 90.0, 90.0, 0);
        this.shineShapes.add(topLine);
        this.shineShapes.add(leftLine);
        this.shineShapes.add(arcTop);
    }

    private RoundRectangle2D getDrawRect(Zoom zoom) {
        if (zoom.isOne()) {
            return this.rect;
        }
        return Zoomer.zoom(this.rect, zoom.getLevel());
    }

    private int getShadowSize(Zoom zoom) {
        double level = zoom.getLevel();
        if (level > 0.99) {
            return 3;
        }
        return 0;
    }
}

