/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d.draw;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.j2d.draw.IDrawableOrderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class DiagramDrawer {
    private final IDrawableOrderer drawableOrderer;
    private int imgMargin = 5;
    private static final int PRINTING_IMG_MARGIN = 5;
    private static final int MIN_DIAGRAM_DIMENSION = 200;

    public DiagramDrawer(IDrawableOrderer orderer) {
        this.drawableOrderer = orderer;
    }

    public void draw(Graphics2D g2, Diagram diagram) {
        Zoom zoom = diagram.getZoom();
        for (IDrawable drawable : this.drawableOrderer.getOrderedDrawables(diagram)) {
            if (drawable == null) continue;
            drawable.draw(g2, zoom);
        }
    }

    public void setImageMargin(int px) {
        this.imgMargin = px;
    }

    public BufferedImage getDiagramImage(Diagram diagram) {
        diagram.refresh();
        double zoomLevel = diagram.getZoom().getLevel();
        Rectangle2D bounds = diagram.getBounds2D();
        Rectangle2D fullBounds = this.getFullDiagramBounds(bounds, zoomLevel);
        BufferedImage image = new BufferedImage((int)fullBounds.getWidth(), (int)fullBounds.getHeight(), 1);
        Graphics2D g2 = image.createGraphics();
        g2.setPaint(Color.BLACK);
        GuiHelper.setBackColor(g2, Color.WHITE, (int)fullBounds.getWidth(), (int)fullBounds.getHeight());
        this.drawBorder(g2, fullBounds);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DiagramDrawer diagramDrawer = new DiagramDrawer(this.drawableOrderer);
        diagramDrawer.draw(g2, diagram);
        g2.dispose();
        return image;
    }

    private Rectangle2D getFullDiagramBounds(Rectangle2D bounds, double zoomLevel) {
        int width = Math.max(200, (int)bounds.getWidth());
        int height = Math.max(200, (int)bounds.getHeight());
        Rectangle2D.Double fullBounds = new Rectangle2D.Double(bounds.getX(), bounds.getY(), zoomLevel * (double)width + (double)this.imgMargin, zoomLevel * (double)height + (double)this.imgMargin);
        return fullBounds;
    }

    private void drawBorder(Graphics2D g2, Rectangle2D bounds) {
        g2.draw3DRect((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth() - 1, (int)bounds.getHeight() - 1, true);
    }
}

