/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.j2d;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.image.ImageUtil;
import com.harrand.dbwrenchgui.diagram.svg.util.SvgExporter;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.j2d.draw.DiagramDrawer;
import com.harrand.sketch.j2d.draw.IDrawableOrderer;
import com.harrand.util.LogUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public final class DiagramExporter {
    public static final int BUFFER_MARGIN = 35;
    public static final String JPEG_FORMAT = "jpg";
    public static final String PNG_FORMAT = "png";
    public static final String SVG_FORMAT = "svg";

    public static void export(Diagram diagram, IDrawableOrderer drawableOrderer, String formatName, File file) throws Exception {
        if (formatName.equalsIgnoreCase(SVG_FORMAT)) {
            DiagramExporter.exportSvg(diagram, file);
        } else {
            DiagramExporter.exportRenderedDiagram(diagram, drawableOrderer, formatName, file);
        }
    }

    private static void exportSvg(Diagram diagram, File file) {
        SvgExporter exporter = new SvgExporter();
        exporter.exportDiagram(file, diagram);
    }

    private static void exportRenderedDiagram(Diagram diagram, IDrawableOrderer drawableOrderer, String formatName, File file) throws Exception {
        RenderedImage image = DiagramExporter.getRenderedImage(diagram, drawableOrderer);
        ImageIO.write(image, formatName, file);
        image = null;
        System.gc();
        System.gc();
    }

    private static RenderedImage getRenderedImage(Diagram diagram, IDrawableOrderer drawableOrderer) {
        DiagramDrawer diagramDrawer = new DiagramDrawer(drawableOrderer);
        return diagramDrawer.getDiagramImage(diagram);
    }

    private static BufferedImage getHiResImage(BufferedImage bufImg) {
        int res_w = 300;
        int res_h = 300;
        double w = bufImg.getWidth();
        double h = bufImg.getHeight();
        double newW = w * (double)res_w / 72.0;
        double newH = h * (double)res_h / 72.0;
        BufferedImage bigImg = GuiHelper.getBufferedImage((int)newW, (int)newH, true);
        Graphics2D bigGfx = (Graphics2D)bigImg.getGraphics();
        bigGfx.drawImage(bufImg, 0, 0, (int)newW, (int)newH, null);
        return bigImg;
    }

    public static void setBackColor(Graphics2D g2, Color color, Rectangle2D bounds) {
        Paint oldPaint = g2.getPaint();
        g2.setPaint(color);
        g2.fill(bounds);
        g2.setPaint(oldPaint);
    }

    private static void drawBorder(Graphics2D g2, Rectangle2D bounds) {
        g2.draw3DRect((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth() - 1, (int)bounds.getHeight() - 1, true);
    }

    public static String mapToFileUseName(String formatName) {
        String fileUseName = "";
        if (formatName.equals(JPEG_FORMAT)) {
            fileUseName = "JPEG";
        } else if (formatName.equals(PNG_FORMAT)) {
            fileUseName = "PNG";
        } else if (formatName.equals(SVG_FORMAT)) {
            fileUseName = "SVG";
        } else {
            LogUtil.logErr("DiagramExporter: FileUseName Unknown formatName: " + formatName);
        }
        return fileUseName;
    }

    public static String getFileExtension(String formatName) {
        String extension = "";
        if (formatName.equals(JPEG_FORMAT)) {
            extension = JPEG_FORMAT;
        } else if (formatName.equals(PNG_FORMAT)) {
            extension = PNG_FORMAT;
        } else {
            LogUtil.logErr("DiagramExporter: Extension Unknown formatName: " + formatName);
        }
        return extension;
    }

    public static void writeImageToFile(ImageIcon image, File file, int width, int height) throws Exception {
        BufferedImage bufImg = ImageUtil.toBufferedImage(image.getImage());
        ImageIO.write((RenderedImage)bufImg, PNG_FORMAT, file);
    }
}

