/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.glyph.footer;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.config.rc.IRenderConfigSrc;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.xml.svg.bldr.basic.SvgGradientBldr;
import com.harrand.sketch.xml.svg.common.ISvgGradientable;
import com.harrand.sketch.xml.svg.common.ISvgShape;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class FooterGlyph
implements ISvgShape,
ISvgGradientable {
    private Color bgColor = Colors.getGrayVeryLight();
    private int radius;
    private Point coordSpace = new Point();
    private RoundRectangle2D rect;
    private Point origin_ = new Point(0, 0);
    private boolean useGradient = true;
    private IRenderConfigSrc rcSrc;
    private int width;
    private static final int HEIGHT_PX = 4;

    public FooterGlyph(IRenderConfigSrc rcSrc, int width) {
        this.width = width;
        this.rcSrc = rcSrc;
        this.doCalcs();
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.doCalcs();
    }

    public void setCoordSpace(Point coordSpace) {
        this.coordSpace = coordSpace;
    }

    public Point getCoordSpace() {
        return this.coordSpace;
    }

    public void setWidth(int width) {
        this.width = width;
        this.doCalcs();
    }

    public int getHeight() {
        return (int)this.rect.getHeight();
    }

    public void setOrigin(Point origin) {
        this.origin_ = origin;
    }

    public boolean getUseGradient() {
        return this.useGradient;
    }

    public void setUseGradient(boolean useGradient) {
        this.useGradient = useGradient;
    }

    private EnhancedShape getEShape() {
        EnhancedShape eShape = new EnhancedShape(this.rect, this.bgColor);
        eShape.setIsFilled(true);
        eShape.setFillColor(this.bgColor);
        return eShape;
    }

    public List getShapes() {
        ArrayList<EnhancedShape> shapes = new ArrayList<EnhancedShape>();
        shapes.add(this.getEShape());
        return shapes;
    }

    private void doCalcs() {
        double height = FooterGlyph.getHeight(this.rcSrc.getRenderConfig());
        this.rect = new RoundRectangle2D.Double(this.origin_.getX(), this.origin_.getY(), this.width, height, this.radius, this.radius);
    }

    public static int getHeight(RenderConfig rc) {
        return (int)(4.0 * rc.getScaleFactor());
    }

    @Override
    public Element getSvgElm(Document doc) {
        return null;
    }

    @Override
    public Element getGradientElm(Document doc) {
        SvgGradientBldr elmBldr = new SvgGradientBldr(doc);
        return elmBldr.buildElm(Color.WHITE, this.bgColor);
    }

    @Override
    public String getGradientIdStr() {
        return StrHelper.getGradientIdString(Color.WHITE, this.bgColor);
    }
}

