/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.glyph;

import com.harrand.coreclasses.display.IColorable;
import com.harrand.coreclasses.element.IDiagramCopyable;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.dirty.IDirtyTrackable;
import com.harrand.coreclasses.notification.dirty.IDirtyTracker;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.Icons;
import com.harrand.coregui.mouse.tracker.IMouseTracker;
import com.harrand.dbwrench.diagram.hilight.color.IColorScheme;
import com.harrand.sketch.command.clickAction.bldr.ZoneClickActionBldr;
import com.harrand.sketch.command.clickAction.ctrl.BasicClickActionCtrl;
import com.harrand.sketch.command.clickAction.ctrl.IClickActionCtrl;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.GlyphBox;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.config.rc.IRenderConfigSrc;
import com.harrand.sketch.glyph.AnchorGlyph;
import com.harrand.sketch.glyph.HeaderGlyph;
import com.harrand.sketch.glyph.interfaces.IDetailableGlyph;
import com.harrand.sketch.glyph.interfaces.IIdfGlyph;
import com.harrand.sketch.glyph.mouse.BasicGlyphMouseTracker;
import com.harrand.sketch.interfaces.IAutoAddedGlyph;
import com.harrand.sketch.interfaces.IGradientable;
import com.harrand.sketch.interfaces.IHilightableGlyph;
import com.harrand.sketch.interfaces.IObjGlyph;
import com.harrand.sketch.interfaces.IPreImagedGlyph;
import com.harrand.sketch.interfaces.IResizableGlyph;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.object.AnchorSelect;
import com.harrand.sketch.object.Zone;
import com.harrand.sketch.support.DrawableUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ZoneGlyph
implements Glyph,
IObserver,
IColorable,
IDirtyTrackable,
IPreImagedGlyph,
IHilightableGlyph,
IIdfGlyph,
IRefreshable,
IGradientable,
IResizableGlyph,
IDiagramCopyable,
IObjGlyph,
IDrawable,
IMouseTracker,
IRenderConfigSrc,
IDetailableGlyph,
IAutoAddedGlyph {
    private Diagram diagram_;
    private final Zone zone_;
    private RenderConfig rc_;
    private final GlyphBox glyphBox_ = new GlyphBox();
    private List<AnchorGlyph> anchors_ = new ArrayList<AnchorGlyph>();
    private final HeaderGlyph headerGlyph_;
    private final AnchorSelect anchorSelect_ = new AnchorSelect();
    private final List allShapes = new ArrayList();
    private boolean useGradient_ = false;
    private boolean isRefreshing_;
    private IDirtyTracker dirtyTracker_;
    private final IMouseTracker mouseTracker;
    private final IClickActionCtrl clickActionCtrl;
    private final ZoneClickActionBldr clickActionBldr;
    private static final BufferedImage typeImg_ = Icons.getBufferedImage("Zone");
    public static final int VERT_SPACER_COUNT = 4;
    public static final int SHADING_WIDTH_LOCAL = 2;
    private static final int CORNER_RADIUS = 4;

    public ZoneGlyph(Diagram diagram, Zone zone) {
        this.zone_ = zone;
        this.zone_.addObserver(this);
        this.headerGlyph_ = new HeaderGlyph(new RenderConfig(1.0), (int)this.zone_.getBounds().getWidth(), this.getDisplayNm());
        this.headerGlyph_.setContainingRectRadius(4);
        this.initDiagram(diagram);
        this.clickActionBldr = new ZoneClickActionBldr(this);
        this.clickActionCtrl = new BasicClickActionCtrl(this.clickActionBldr, this);
        this.mouseTracker = new BasicGlyphMouseTracker(this.clickActionCtrl, this, this, diagram, this.zone_);
        this.init();
        this.refresh();
    }

    public String getDisplayNm() {
        return this.zone_.getName();
    }

    public Font getTitleFont() {
        return this.headerGlyph_.getFont();
    }

    private void init() {
        this.glyphBox_.setShadingFlag(false);
        this.glyphBox_.setShadingWidth(2);
        this.glyphBox_.setColor("MainBox", this.zone_.getColor());
        this.glyphBox_.setCornerRadius(4);
        this.glyphBox_.setUseGradient(this.useGradient_);
        this.headerGlyph_.setBgColor(this.zone_.getColor());
        this.headerGlyph_.setTypeImg(typeImg_);
        this.headerGlyph_.setSvgIconId("zone_icon");
    }

    private void initDiagram(Diagram diagram) {
        this.diagram_ = diagram;
        this.rc_ = this.diagram_.getRenderConfig();
        this.headerGlyph_.setRenderConfig(this.rc_);
    }

    @Override
    public void resize(Rectangle newRect) {
        this.zone_.setRect(newRect);
        this.refresh();
        this.notifyDirty();
    }

    public Diagram getDiagram() {
        return this.diagram_;
    }

    public Zone getZone() {
        return this.zone_;
    }

    @Override
    public Object getGlyphObject() {
        return this.getZone();
    }

    public HeaderGlyph getHeaderGlyph() {
        return this.headerGlyph_;
    }

    private void calcBox() {
        Rectangle zoneRect = this.zone_.getBounds();
        this.glyphBox_.setBoxRect(zoneRect.x, zoneRect.y, zoneRect.width, zoneRect.height);
        this.headerGlyph_.setCoordSpace(new Point(zoneRect.x, zoneRect.y));
    }

    private void loadSettings() {
        this.rc_ = this.diagram_.getRenderConfig();
        this.headerGlyph_.setRenderConfig(this.rc_);
        this.glyphBox_.setRenderConfig(this.rc_);
    }

    private void refreshGlyphObjects() {
        Rectangle zoneBounds = this.zone_.getBounds();
        this.headerGlyph_.setText(this.getDisplayNm());
        this.headerGlyph_.setOrigin(new Point(1, 1));
        this.headerGlyph_.setWidth(zoneBounds.width - 2);
        Collection<IDrawable> clickActionDrawables = this.clickActionCtrl.getDrawables();
        this.allShapes.clear();
        this.allShapes.add(this.headerGlyph_);
        this.allShapes.addAll(clickActionDrawables);
        this.allShapes.addAll(this.headerGlyph_.getDrawables());
        this.glyphBox_.setAddedShapes(this.allShapes);
    }

    @Override
    public void refresh() {
        this.isRefreshing_ = true;
        this.loadSettings();
        this.calcBox();
        this.refreshGlyphObjects();
        this.refreshAnchors();
        this.glyphBox_.refresh();
        this.diagram_.refresh();
        this.isRefreshing_ = false;
    }

    private void updateDisp() {
        this.clickActionBldr.clear();
    }

    @Override
    public void update(UpdateChain chain) {
        if (this.isRefreshing_) {
            return;
        }
        if (chain.hasClassName(Zone.getClassName())) {
            this.updateDisp();
        }
        if (chain.hasClassName(Diagram.getClassName())) {
            this.updateDisp();
        }
    }

    @Override
    public AnchorGlyph getSelectedAnchor(Point2D p) {
        for (AnchorGlyph anchor : this.anchors_) {
            if (!anchor.contains(p)) continue;
            return anchor;
        }
        return null;
    }

    @Override
    public Rectangle getResizeRect(AnchorGlyph selectAnchor, Point dragPt) {
        double zoomLevel = this.diagram_.getZoom().getLevel();
        return this.anchorSelect_.getResizeRect(selectAnchor, dragPt, zoomLevel);
    }

    private boolean getAnchorsContain(Point2D p) {
        boolean contains = this.getSelectedAnchor(p) != null;
        return contains;
    }

    @Override
    public String getName() {
        return this.zone_.getQN();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.glyphBox_.getBounds2D();
    }

    @Override
    public boolean contains(Point2D p) {
        boolean boxContains = this.getBounds2D().contains(p);
        boolean anchorsContain = false;
        if (!boxContains) {
            anchorsContain = this.getAnchorsContain(p);
        }
        return boxContains || anchorsContain;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    @Override
    public void move(Point p) {
        this.zone_.setOrigin(p);
        this.calcBox();
        this.refreshAnchors();
        this.notifyDirty();
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean getSelected() {
        return this.glyphBox_.getSelected();
    }

    @Override
    public void setSelected(boolean selected) {
        this.glyphBox_.setSelected(selected);
    }

    @Override
    public void setAngle(double angle) {
    }

    @Override
    public void setScaleFactor(double scaleFactor) {
    }

    @Override
    public void setName(String newName) {
    }

    public List getDrawables() {
        ArrayList shapes = new ArrayList();
        shapes.addAll(this.glyphBox_.getDrawables());
        return shapes;
    }

    @Override
    public Color getColor(String key) {
        return this.zone_.getColor();
    }

    @Override
    public List getKeys() {
        return this.glyphBox_.getKeys();
    }

    @Override
    public void setColor(String key, Color color) {
        this.glyphBox_.setColor(key, color);
        this.headerGlyph_.setBgColor(color);
        this.zone_.setColor(color);
        this.refresh();
        this.notifyDirty();
    }

    @Override
    public void setDirtyTracker(IDirtyTracker tracker) {
        this.dirtyTracker_ = tracker;
    }

    private void notifyDirty() {
        if (this.dirtyTracker_ != null) {
            this.dirtyTracker_.notifyDirty(this);
        }
    }

    @Override
    public BufferedImage getImage() {
        return this.glyphBox_.getImage();
    }

    @Override
    public List<IDrawable> getHilightDrawables(Diagram diagram) {
        boolean singleSelection;
        int selectCnt = this.diagram_.getSelectedGlyphs(true).size();
        boolean bl = singleSelection = selectCnt == 1;
        if (singleSelection) {
            return new ArrayList<IDrawable>(this.getAnchors());
        }
        return this.glyphBox_.getHilightDrawables(this.diagram_);
    }

    private void refreshAnchors() {
        Rectangle objRect = this.glyphBox_.getBounds();
        this.anchors_ = this.anchorSelect_.getAnchors(objRect);
    }

    private List<AnchorGlyph> getAnchors() {
        return this.anchors_;
    }

    @Override
    public Identifiable getIdf() {
        return this.zone_;
    }

    @Override
    public void setUseGradient(boolean flag) {
        this.useGradient_ = flag;
    }

    @Override
    public boolean getUseGradient() {
        return this.useGradient_;
    }

    @Override
    public IDiagramCopyable copy(Diagram targetDiagram) {
        Zone copyZone = new Zone(this.getDisplayNm(), this.zone_.getText(), GeometryHelper.getRect(this.zone_.getBounds()));
        copyZone.setColor(this.zone_.getColor());
        targetDiagram.add(copyZone);
        String qn = copyZone.getQN();
        ZoneGlyph copy = (ZoneGlyph)targetDiagram.getGlyph(qn);
        return copy;
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        DrawableUtil.drawPreImaged(this, g2, zoom);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseTracker.mouseMoved(e);
    }

    @Override
    public boolean mouseDown(MouseEvent e) {
        return this.mouseTracker.mouseDown(e);
    }

    @Override
    public void mouseUp(MouseEvent e) {
        this.mouseTracker.mouseUp(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseTracker.mouseExited(e);
    }

    @Override
    public RenderConfig getRenderConfig() {
        return this.diagram_.getRenderConfig();
    }

    @Override
    public void setColorScheme(IColorScheme colorScheme) {
        this.glyphBox_.setColorScheme(colorScheme);
    }
}

