/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.glyph;

import com.harrand.coreclasses.display.IColorable;
import com.harrand.coreclasses.element.IDiagramCopyable;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.dirty.IDirtyTrackable;
import com.harrand.coreclasses.notification.dirty.IDirtyTracker;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.Icons;
import com.harrand.coregui.mouse.tracker.IMouseTracker;
import com.harrand.dbwrench.diagram.hilight.color.IColorScheme;
import com.harrand.sketch.command.clickAction.bldr.NoteClickActionBldr;
import com.harrand.sketch.command.clickAction.ctrl.BasicClickActionCtrl;
import com.harrand.sketch.command.clickAction.ctrl.IClickActionCtrl;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.GlyphBox;
import com.harrand.sketch.core.GlyphImage;
import com.harrand.sketch.core.GlyphTextLine;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.config.rc.IRenderConfigSrc;
import com.harrand.sketch.glyph.GlyphPosUtil;
import com.harrand.sketch.glyph.interfaces.IDetailableGlyph;
import com.harrand.sketch.glyph.interfaces.IIdfGlyph;
import com.harrand.sketch.glyph.mouse.BasicGlyphMouseTracker;
import com.harrand.sketch.interfaces.IAutoAddedGlyph;
import com.harrand.sketch.interfaces.IGradientable;
import com.harrand.sketch.interfaces.IHilightableGlyph;
import com.harrand.sketch.interfaces.IObjGlyph;
import com.harrand.sketch.interfaces.IPreImagedGlyph;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.object.Note;
import com.harrand.sketch.support.DrawableUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class NoteGlyph
implements Glyph,
IObserver,
IColorable,
IDirtyTrackable,
IPreImagedGlyph,
IHilightableGlyph,
IGradientable,
IIdfGlyph,
IRefreshable,
IDiagramCopyable,
IObjGlyph,
IDetailableGlyph,
IDrawable,
IMouseTracker,
IRenderConfigSrc,
IAutoAddedGlyph {
    private Diagram diagram_;
    private final Note note_;
    private final GlyphBox glyphBox_ = new GlyphBox();
    private RenderConfig rc_;
    private int yPos_ = 0;
    private final GlyphPosUtil posUtil_ = new GlyphPosUtil();
    private final List<String> textStrs_ = new ArrayList<String>();
    private List<GlyphTextLine> textLines_ = new ArrayList<GlyphTextLine>();
    private List<GlyphImage> glyphImgs_ = new ArrayList<GlyphImage>();
    private boolean isRefreshing_;
    private boolean useGradient_ = true;
    private IDirtyTracker dirtyTracker_;
    private final IMouseTracker mouseTracker;
    private final IClickActionCtrl clickActionCtrl;
    private final List allShapes = new ArrayList();
    private Point2D lastTypeGlyphOrigin = new Point2D.Double();
    private final NoteClickActionBldr clickActionBldr;
    private static final BufferedImage typeImg_ = Icons.getBufferedImage("Note");
    public static final int VERT_SPACER_COUNT = 4;
    public static final int SHADING_WIDTH_LOCAL = 2;
    private static final int CORNER_RADIUS = 4;
    private Point start;

    public NoteGlyph(Diagram diagram, Note note) {
        this.note_ = note;
        this.note_.addObserver(this);
        this.posUtil_.setHasImagesColumns(false);
        this.initDiagram(diagram);
        this.posUtil_.setRenderConfig(this.rc_);
        this.clickActionBldr = new NoteClickActionBldr(this);
        this.clickActionCtrl = new BasicClickActionCtrl(this.clickActionBldr, this);
        this.mouseTracker = new BasicGlyphMouseTracker(this.clickActionCtrl, this, this, diagram, this.note_);
        this.init();
        this.refresh();
    }

    private void init() {
        this.glyphBox_.setShadingFlag(false);
        this.glyphBox_.setShadingWidth(2);
        this.glyphBox_.setColor("MainBox", this.note_.getColor());
        this.glyphBox_.setUseGradient(this.useGradient_);
        this.glyphBox_.setCornerRadius(4);
    }

    private void initDiagram(Diagram diagram) {
        this.diagram_ = diagram;
        this.rc_ = this.diagram_.getRenderConfig();
    }

    public void setDiagram(Diagram diagram) {
        this.initDiagram(diagram);
        this.refresh();
    }

    public Diagram getDiagram() {
        return this.diagram_;
    }

    public Note getNote() {
        return this.note_;
    }

    @Override
    public Object getGlyphObject() {
        return this.getNote();
    }

    public Point2D getLastTypeGlyphOrigin() {
        return this.lastTypeGlyphOrigin;
    }

    private void calcBox() {
        this.splitText();
        int linesCnt = this.textStrs_.size() + 1;
        int boxHeight = this.posUtil_.getLineHeight() * linesCnt + 8;
        int boxWidth = this.posUtil_.getApproxBoxWidth(this.textStrs_);
        this.start = this.note_.getOrigin();
        this.glyphBox_.setBoxRect(this.start.x, this.start.y, boxWidth, boxHeight);
    }

    private void loadSettings() {
        this.rc_ = this.diagram_.getRenderConfig();
        this.posUtil_.setRenderConfig(this.rc_);
        this.glyphBox_.setRenderConfig(this.rc_);
    }

    private void refreshGlyphObjects() {
        this.textLines_ = new ArrayList<GlyphTextLine>();
        this.glyphImgs_ = new ArrayList<GlyphImage>();
        this.yPos_ = 0;
        this.addVertSpacer();
        this.addLineFeed();
        GlyphImage typeGlyph = this.getTypeGlyph();
        this.glyphImgs_.add(typeGlyph);
        this.lastTypeGlyphOrigin = typeGlyph.getStart();
        this.addLineFeed();
        for (String str : this.textStrs_) {
            Point lineStart = new Point(this.getTextIndent(), this.yPos_);
            GlyphTextLine textLine = new GlyphTextLine(str, lineStart, this.rc_.getFont(), 0, Color.BLACK);
            textLine.setCoordSpace(this.start);
            this.textLines_.add(textLine);
            this.addLineFeed();
        }
        Collection<IDrawable> clickActionDrawables = this.clickActionCtrl.getDrawables();
        this.allShapes.clear();
        this.allShapes.addAll(this.textLines_);
        this.allShapes.addAll(clickActionDrawables);
        this.allShapes.addAll(this.glyphImgs_);
        this.glyphBox_.setAddedShapes(this.allShapes);
    }

    private GlyphImage getTypeGlyph() {
        int xMiddle = (int)(this.getBounds2D().getWidth() / 2.0);
        return this.posUtil_.getCenteredGlyphImg(typeImg_, xMiddle, this.yPos_ + 1, "note_icon", this.start);
    }

    private void addLineFeed() {
        this.yPos_ += this.posUtil_.getLineHeight();
    }

    private int getTextIndent() {
        return this.posUtil_.getIconSpace();
    }

    private void splitText() {
        String text = this.note_.getText();
        String[] parts = text.split("\\n");
        this.textStrs_.clear();
        this.textStrs_.addAll(Arrays.asList(parts));
    }

    private void addVertSpacer() {
        this.yPos_ += 2;
    }

    @Override
    public void refresh() {
        this.isRefreshing_ = true;
        this.loadSettings();
        this.calcBox();
        this.refreshGlyphObjects();
        this.glyphBox_.refresh();
        this.diagram_.refresh();
        this.isRefreshing_ = false;
    }

    private void updateDisp() {
        this.clickActionBldr.clear();
    }

    @Override
    public void update(UpdateChain chain) {
        if (this.isRefreshing_) {
            return;
        }
        if (chain.hasClassName(Note.getClassName())) {
            this.updateDisp();
        }
        if (chain.hasClassName(Diagram.getClassName())) {
            this.updateDisp();
        }
    }

    @Override
    public String getName() {
        return this.note_.getQN();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.glyphBox_.getBounds2D();
    }

    @Override
    public boolean contains(Point2D p) {
        return this.getBounds2D().contains(p);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    @Override
    public void move(Point p) {
        this.note_.setOrigin(p);
        this.calcBox();
        this.notifyDirty();
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean getSelected() {
        return this.glyphBox_.getSelected();
    }

    @Override
    public void setSelected(boolean selected) {
        this.glyphBox_.setSelected(selected);
    }

    @Override
    public void setAngle(double angle) {
    }

    @Override
    public void setScaleFactor(double scaleFactor) {
    }

    @Override
    public void setName(String newName) {
    }

    public List getDrawables() {
        ArrayList shapes = new ArrayList();
        shapes.addAll(this.glyphBox_.getDrawables());
        return shapes;
    }

    @Override
    public Color getColor(String key) {
        return this.note_.getColor();
    }

    @Override
    public List getKeys() {
        return this.glyphBox_.getKeys();
    }

    @Override
    public void setColor(String key, Color color) {
        this.glyphBox_.setColor(key, color);
        this.note_.setColor(color);
        this.refresh();
        this.notifyDirty();
    }

    @Override
    public void setDirtyTracker(IDirtyTracker tracker) {
        this.dirtyTracker_ = tracker;
    }

    private void notifyDirty() {
        if (this.dirtyTracker_ != null) {
            this.dirtyTracker_.notifyDirty(this);
        }
    }

    @Override
    public BufferedImage getImage() {
        return this.glyphBox_.getImage();
    }

    @Override
    public List<IDrawable> getHilightDrawables(Diagram diagram) {
        return this.glyphBox_.getHilightDrawables(diagram);
    }

    @Override
    public Identifiable getIdf() {
        return this.note_;
    }

    @Override
    public void setUseGradient(boolean flag) {
        this.useGradient_ = flag;
    }

    @Override
    public boolean getUseGradient() {
        return this.useGradient_;
    }

    @Override
    public IDiagramCopyable copy(Diagram targetDiagram) {
        Note noteCopy = new Note(this.note_.getText(), this.note_.getOrigin());
        noteCopy.setColor(this.note_.getColor());
        targetDiagram.add(noteCopy);
        String copyNoteQN = noteCopy.getQN();
        NoteGlyph copy = (NoteGlyph)targetDiagram.getGlyph(copyNoteQN);
        return copy;
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        DrawableUtil.drawPreImaged(this, g2, zoom);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseTracker.mouseMoved(e);
    }

    @Override
    public boolean mouseDown(MouseEvent e) {
        return this.mouseTracker.mouseDown(e);
    }

    @Override
    public void mouseUp(MouseEvent e) {
        this.mouseTracker.mouseUp(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseTracker.mouseExited(e);
    }

    @Override
    public RenderConfig getRenderConfig() {
        return this.diagram_.getRenderConfig();
    }

    @Override
    public void setColorScheme(IColorScheme colorScheme) {
        this.glyphBox_.setColorScheme(colorScheme);
    }
}

