/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.glyph;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.sketch.core.GlyphImage;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.drawable.TextDrawable;
import com.harrand.sketch.glyph.GlyphPosUtil;
import com.harrand.sketch.glyph.header.HeaderTextXCalc;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.xml.svg.bldr.basic.SvgGradientBldr;
import com.harrand.sketch.xml.svg.bldr.glyph.SvgHeaderGlyphBldr;
import com.harrand.sketch.xml.svg.common.ISvgGradientable;
import com.harrand.sketch.xml.svg.common.ISvgShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HeaderGlyph
implements IDrawable,
ISvgShape,
ISvgGradientable {
    private RenderConfig rc;
    private GlyphPosUtil posUtil_ = new GlyphPosUtil();
    private Rectangle rect_;
    private int width;
    private String text_;
    private BufferedImage typeImg_;
    private GlyphImage glyphImg_;
    private Point origin_ = new Point(0, 0);
    private boolean useGradient = true;
    private HeaderTextXCalc headerTextPosX = HeaderTextXCalc.AFTER_LEFT_ICON;
    private Point textOrigin_;
    private Color bgColor_ = Colors.getGrayVeryLight();
    private Font enlargedBoldFont = null;
    private String name;
    private Point coordSpace = new Point();
    private String svgIconId;
    private int containingRectRadius;

    public HeaderGlyph(RenderConfig rc, int width, String text) {
        this.width = width;
        this.setText(text);
        this.setRenderConfig(rc);
    }

    public final void setText(String text) {
        this.text_ = text;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor_ = bgColor;
    }

    public Font getFont() {
        return this.enlargedBoldFont;
    }

    public Color getColor() {
        return this.bgColor_;
    }

    public String getText() {
        return this.text_;
    }

    public void setContainingRectRadius(int containingRectRadius) {
        this.containingRectRadius = containingRectRadius;
    }

    public int getContainingRectRadius() {
        return this.containingRectRadius;
    }

    public GlyphImage getGlyphImg() {
        return this.glyphImg_;
    }

    public void setCoordSpace(Point coordSpace) {
        this.coordSpace = coordSpace;
    }

    public Point getCoordSpace() {
        return this.coordSpace;
    }

    public Rectangle getRect() {
        return this.rect_;
    }

    public Point getTextOrigin() {
        return this.textOrigin_;
    }

    public void setWidth(int width) {
        this.width = width;
        this.doCalcs();
    }

    public void setOrigin(Point origin) {
        this.origin_ = origin;
    }

    public boolean getUseGradient() {
        return this.useGradient;
    }

    public void setUseGradient(boolean useGradient) {
        this.useGradient = useGradient;
    }

    public void setTypeImg(BufferedImage typeImg) {
        this.typeImg_ = typeImg;
    }

    public void setSvgIconId(String svgIconid) {
        this.svgIconId = svgIconid;
    }

    public final void setRenderConfig(RenderConfig rc) {
        this.rc = rc;
        this.posUtil_.setRenderConfig(rc);
        Font baseFont = rc.getFont();
        this.enlargedBoldFont = GuiHelper.getEnlargedBoldFont(baseFont);
        this.doCalcs();
    }

    public List<IDrawable> getDrawables() {
        ArrayList<IDrawable> drawables = new ArrayList<IDrawable>();
        drawables.add(this.getTextDrawable());
        return drawables;
    }

    private Paint getGradientPaint() {
        return GuiHelper.getGradientPaint(this.rect_.getBounds(), this.bgColor_);
    }

    private Paint getPaint() {
        Paint paint = this.getUseGradient() ? this.getGradientPaint() : this.bgColor_;
        return paint;
    }

    private TextDrawable getTextDrawable() {
        String nm = this.getName() + ".drawable";
        TextDrawable textDrawable = new TextDrawable(nm, this.text_, this.enlargedBoldFont, this.textOrigin_);
        return textDrawable;
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        Paint oldPaint = g2.getPaint();
        Paint paint = this.getPaint();
        g2.setPaint(paint);
        g2.fill(this.rect_);
        g2.setPaint(oldPaint);
        if (this.glyphImg_ != null) {
            this.glyphImg_.draw(g2, zoom);
        }
    }

    public void setHeaderTextXCalc(HeaderTextXCalc calc) {
        this.headerTextPosX = calc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void doCalcs() {
        int lineHeight = GuiHelper.getFontLineHeight(this.enlargedBoldFont);
        int rectHeight = 4 + lineHeight;
        this.rect_ = new Rectangle(this.origin_.x, this.origin_.y, this.width, rectHeight);
        int vertMargin = GuiHelper.getVertTextMargin(lineHeight);
        int textX = this.headerTextPosX.getXPos(this.rc, this.getText(), this.getWidth());
        int yPos = lineHeight + 2;
        int textY = yPos - vertMargin;
        this.textOrigin_ = new Point(textX, textY);
        if (this.typeImg_ != null) {
            this.glyphImg_ = this.posUtil_.getLeftAlignedGlyphImg(this.typeImg_, yPos - 1, this.svgIconId, this.coordSpace);
        }
    }

    private int getWidth() {
        return this.width;
    }

    @Override
    public Element getSvgElm(Document doc) {
        SvgHeaderGlyphBldr bldr = new SvgHeaderGlyphBldr(this);
        return bldr.getSvgElm(doc);
    }

    @Override
    public Element getGradientElm(Document doc) {
        SvgGradientBldr elmBldr = new SvgGradientBldr(doc);
        return elmBldr.buildElm(Color.WHITE, this.bgColor_);
    }

    @Override
    public String getGradientIdStr() {
        return StrHelper.getGradientIdString(Color.WHITE, this.bgColor_);
    }
}

