/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.glyph;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.diagram.DbVerbosity;
import com.harrand.sketch.core.GlyphImage;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.glyph.calc.IconGlyphSizeCalc;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.List;

public class GlyphPosUtil {
    private RenderConfig rc_;
    private int lineHeight_;
    private double boxWidth;
    private Point coordSpace;
    private int vertFiller;
    private IconGlyphSizeCalc iconGlyphSizeCalc = new IconGlyphSizeCalc();
    private boolean hasImagesColumn_ = true;
    public static final int IMG_PADDING = 2;
    public static final int EDGE_PADDING = 2;
    public static final int SIDE_PADDING = 7;
    public static final int TBL_ROW_Y_MARGIN = 2;
    public static final int TEXT_SIDE_PAD = 3;

    public Font getFont() {
        return this.rc_.getFont();
    }

    public Font getHeaderFont() {
        return this.rc_.getHeaderFont();
    }

    public int getImageY(int yPos) {
        return yPos + 2 - this.lineHeight_ + this.vertFiller;
    }

    public int getImageYb(int yPos) {
        return yPos + 2 - this.lineHeight_ + this.vertFiller + 1;
    }

    public int getPreviousIconSpace(int iconPos) {
        return (iconPos - 1) * (this.getIconSpace() + 4);
    }

    public int getSpaceFromNm(int iconPos) {
        return iconPos == 1 ? 3 : 0;
    }

    public void setRenderConfig(RenderConfig rc) {
        this.rc_ = rc;
        this.reCalcFields();
    }

    private int getRightPositionX(int rightPos) {
        return (int)this.boxWidth - 2 - rightPos * this.getIconSpace();
    }

    private void reCalcFields() {
        this.lineHeight_ = GuiHelper.getFontLineHeight(this.getFont());
        this.calcVertFiller();
    }

    public void setBoxWidth(double boxWidth) {
        this.boxWidth = boxWidth;
    }

    public void setCoordSpace(Point coordSpace) {
        this.coordSpace = coordSpace;
    }

    public void setHasImagesColumns(boolean hasColumn) {
        this.hasImagesColumn_ = hasColumn;
    }

    public int getLineHeight() {
        return this.lineHeight_;
    }

    public int getApproxBoxWidth(List<String> strs) {
        int maxWidth = GuiHelper.getMaxStringWidth(this.getFont(), strs);
        int boxWidth = maxWidth + 2 * this.getIconSpace();
        return boxWidth;
    }

    public GlyphImage getLeftAlignedGlyphImg(BufferedImage img, int yPos, String svgIconId, Point coordSpace) {
        Point topLeft = new Point(2, this.getImageY(yPos));
        GlyphImage glyphImage = this.getImg(img, topLeft);
        this.checkSetSvgIconId(svgIconId, glyphImage);
        glyphImage.setCoordSpace(coordSpace);
        return glyphImage;
    }

    public Point2D getAfterColumnNmTopLeft(String colNm, int cursorY, int iconPos) {
        int textWidth = GuiHelper.getSwingStringLength(colNm, this.getFont());
        int pkIconWidth = this.getIconSpace();
        int gapFromNm = this.getSpaceFromNm(iconPos);
        int previousIconsSpace = this.getPreviousIconSpace(iconPos);
        double x = pkIconWidth + textWidth + gapFromNm + previousIconsSpace;
        double y = this.getImageYb(cursorY);
        Point2D.Double topLeft = new Point2D.Double(x, y);
        return topLeft;
    }

    public Point2D getRightPositionTopLeft(int rightPos, int cursorY) {
        double x = this.getRightPositionX(rightPos);
        double y = this.getImageYb(cursorY);
        Point2D.Double topLeft = new Point2D.Double(x, y);
        return topLeft;
    }

    public Point2D getTableRightPositionTopLeft(int rightPos) {
        double x = this.getRightPositionX(rightPos);
        return new Point2D.Double(x, this.getTableRowY());
    }

    public Point2D getTableLeftPositionTopLeft(int leftPos) {
        return new Point2D.Double(2.0, this.getTableRowY());
    }

    public Point2D getAfterTableNmTopLeft(String nmStr, double nmStartX, int iconPos) {
        Font font = this.getHeaderFont();
        int textWidth = GuiHelper.getSwingStringLength(nmStr, font);
        int spaceFromNm = this.getSpaceFromNm(iconPos);
        int previousIconsSpace = this.getPreviousIconSpace(iconPos);
        double x = nmStartX + (double)textWidth + (double)spaceFromNm + (double)previousIconsSpace;
        return new Point2D.Double(x, this.getTableRowY());
    }

    public Point2D getTableNmBtmLeft(String titleStr) {
        double x = this.getIconSpace();
        double y = this.getLineHeight() + 2;
        int textLength = GuiHelper.getSwingStringLength(titleStr, this.getHeaderFont());
        boolean showCmm = this.rc_.getVerbosityConfig().getShowFlag(DbVerbosity.getKeyComment());
        if (!showCmm) {
            double moveX;
            double deleteIconWidth = this.getIconSpace();
            x = moveX = 0.5 * (this.boxWidth - (double)textLength - deleteIconWidth);
        }
        Point2D.Double btmLeft = new Point2D.Double(x, y);
        return btmLeft;
    }

    private double getTableRowY() {
        int cursorY = this.getLineHeight() + 2;
        double y = this.getImageYb(cursorY);
        return y;
    }

    public GlyphImage createGlyphImg(BufferedImage img, Point2D topLeft, String svgIconId) {
        GlyphImage glyphImage = this.getImg(img, topLeft);
        this.checkSetSvgIconId(svgIconId, glyphImage);
        glyphImage.setCoordSpace(this.coordSpace);
        return glyphImage;
    }

    private void checkSetSvgIconId(String svgIconId, GlyphImage glyphImage) {
        if (svgIconId != null) {
            glyphImage.setSvgIconIdStr(svgIconId);
        }
    }

    public GlyphImage getCenteredGlyphImg(BufferedImage img, int xMiddle, int yPos, String svgIconId, Point coordSpace) {
        int x = xMiddle - (int)(0.5 * (double)this.getIconSpace());
        Point topLeft = new Point(x, yPos - this.lineHeight_ + this.vertFiller);
        GlyphImage glyphImage = this.getImg(img, topLeft);
        this.checkSetSvgIconId(svgIconId, glyphImage);
        glyphImage.setCoordSpace(coordSpace);
        return glyphImage;
    }

    public int getIconSpace() {
        return this.iconGlyphSizeCalc.getIconSpace(this.rc_.getScaleFactor());
    }

    private GlyphImage getImg(BufferedImage img, Point2D topLeft) {
        GlyphImage glyphImage = new GlyphImage(img, topLeft);
        double scaleFactor = this.getScaleFactor();
        glyphImage.setScaleFactor(scaleFactor);
        return glyphImage;
    }

    private void calcVertFiller() {
        int sampleGlyphHeight = this.iconGlyphSizeCalc.getIconHeight(this.getScaleFactor());
        int vertExcess = this.lineHeight_ - sampleGlyphHeight;
        double dblFiller = vertExcess > 0 ? (double)(vertExcess / 2) : 0.0;
        this.vertFiller = (int)Math.round(dblFiller);
    }

    private double getScaleFactor() {
        return this.rc_.getScaleFactor();
    }
}

