/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.glyph;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.sketch.command.MoveGlyphs;
import com.harrand.sketch.core.Diagram;
import com.harrand.util.LogUtil;
import java.awt.Point;
import java.util.List;
import java.util.Map;

public class GlyphMoveCtrl {
    private CommandChain cmdChain = CommandChainMgr.getInstance().getCommandChain();
    private Point dragStart;
    private Point lastDragMove;
    private List selectedGlyphs;
    private Map oldLocations;
    private Zoom zoom;

    public void initDrag(Point startPt) {
        this.dragStart = startPt;
        this.lastDragMove = startPt;
        this.oldLocations = null;
    }

    public void moveGlyphsWithDrag(Diagram diagram, Point dragPos) {
        this.initDiagramItems(diagram);
        int deltaX = dragPos.x - this.lastDragMove.x;
        int deltaY = dragPos.y - this.lastDragMove.y;
        MoveGlyphs cmd = new MoveGlyphs(this.selectedGlyphs, this.zoom, deltaX, deltaY);
        cmd.setDoAutoSave(false);
        this.lastDragMove = dragPos;
        if (this.oldLocations == null) {
            this.oldLocations = cmd.getOldLocations();
        }
        cmd.setCommandChain(null);
        this.doCommon(cmd, diagram);
    }

    public void moveGlyphsOnMouseUp(Diagram diagram, Point mousePt) {
        if (this.cmdChain == null) {
            LogUtil.logMsg("GlyphMoveCtrl.cmdChain is NULL.");
        }
        this.initDiagramItems(diagram);
        int deltaX = this.lastDragMove.x - this.dragStart.x;
        int deltaY = this.lastDragMove.y - this.dragStart.y;
        MoveGlyphs cmd = new MoveGlyphs(this.selectedGlyphs, this.zoom, deltaX, deltaY);
        cmd.setOldLocations(this.oldLocations);
        cmd.setCommandChain(this.cmdChain);
        this.doCommon(cmd, diagram);
    }

    private void initDiagramItems(Diagram diagram) {
        this.zoom = diagram.getZoom();
        this.selectedGlyphs = diagram.getSelectedGlyphs(false);
    }

    private void doCommon(MoveGlyphs cmd, Diagram diagram) {
        cmd.setDiagram(diagram);
        cmd.actionPerformed(null);
    }
}

