/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core.hilight;

import com.harrand.coreclasses.display.Colors;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.relation.glyph.JointGlyph;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;

public class JointGlyphHiLighter {
    private JointGlyph joint;
    private List linkLines_;
    private Color color_ = Colors.getBlueHiLightA();
    private double zoomLevel_;
    private double angle_;
    private double radians_;
    private double halfHeight;
    private double width;
    private double originX_;
    private double originY_;
    private double zmHalfHeight;
    private double zmWidth;
    private double zmOriginX_;
    private double zmOriginY_;

    public JointGlyphHiLighter(JointGlyph joint) {
        this.setJoint(joint);
    }

    public void setJoint(JointGlyph joint1) {
        this.joint = joint1;
    }

    public List getHilightShapes(double zoomLevel) {
        this.angle_ = 360.0 - this.joint.getAngle();
        this.radians_ = Math.toRadians(this.angle_);
        this.halfHeight = 0.5 * this.joint.getHeight() + 2.0;
        this.width = this.joint.getLength();
        this.originX_ = this.joint.getStartPoint().getX();
        this.originY_ = this.joint.getStartPoint().getY();
        this.zoomLevel_ = 1.0;
        this.zmHalfHeight = this.zoomLevel_ * this.halfHeight;
        this.zmWidth = this.zoomLevel_ * this.width;
        this.zmOriginX_ = this.zoomLevel_ * this.originX_;
        this.zmOriginY_ = this.zoomLevel_ * this.originY_;
        List selectionShapes = this.getLines();
        return selectionShapes;
    }

    private List getLines() {
        double ax = this.zmOriginX_ + Math.sin(this.radians_) * this.zmHalfHeight;
        double ay = this.zmOriginY_ - Math.cos(this.radians_) * this.zmHalfHeight;
        double bx = this.zmOriginX_ + Math.cos(this.radians_) * this.zmWidth + Math.sin(this.radians_) * this.zmHalfHeight;
        double by = this.zmOriginY_ + Math.sin(this.radians_) * this.zmWidth - Math.cos(this.radians_) * this.zmHalfHeight;
        double cx = this.zmOriginX_ - Math.sin(this.radians_) * this.zmHalfHeight;
        double cy = this.zmOriginY_ + Math.cos(this.radians_) * this.zmHalfHeight;
        double dx = this.zmOriginX_ + Math.cos(this.radians_) * this.zmWidth - Math.sin(this.radians_) * this.zmHalfHeight;
        double dy = this.zmOriginY_ + Math.sin(this.radians_) * this.zmWidth + Math.cos(this.radians_) * this.zmHalfHeight;
        double ex = this.zmOriginX_ + Math.cos(this.radians_) * this.zmWidth;
        double ey = this.zmOriginY_ + Math.sin(this.radians_) * this.zmWidth;
        ArrayList<EnhancedShape> enhancedShapes = new ArrayList<EnhancedShape>();
        enhancedShapes.add(this.createEnhanceShape(ax, ay, bx, by));
        enhancedShapes.add(this.createEnhanceShape(bx, by, ex, ey));
        enhancedShapes.add(this.createEnhanceShape(cx, cy, dx, dy));
        enhancedShapes.add(this.createEnhanceShape(dx, dy, ex, ey));
        return enhancedShapes;
    }

    private EnhancedShape createEnhanceShape(double x1, double y1, double x2, double y2) {
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        EnhancedShape enhanced = new EnhancedShape(line, this.color_);
        return enhanced;
    }
}

