/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core.drawable;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.sketch.j2d.draw.IDrawable;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;

public class TextDrawable
implements IDrawable {
    private String nm;
    private String text;
    private Font font;
    private Point2D origin;

    public TextDrawable(String nm, String text, Font font, Point2D origin) {
        this.nm = nm;
        this.text = text;
        this.font = font;
        this.origin = origin;
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        Paint oldPaint = g2.getPaint();
        g2.setFont(this.font);
        g2.drawString(this.text, (int)this.origin.getX(), (int)this.origin.getY());
        g2.setPaint(oldPaint);
    }

    @Override
    public String getName() {
        return this.nm;
    }

    @Override
    public void setName(String newName) {
        this.nm = newName;
    }

    public Point getOrigin() {
        return new Point((int)this.origin.getX(), (int)this.origin.getY());
    }

    public double getLineHeight() {
        return GuiHelper.getSwingStringHeight(this.font);
    }
}

