/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.util.LogUtil;
import java.util.ArrayList;
import java.util.TreeMap;

public class VerbosityConfig
implements IObservable,
Identifiable {
    private TreeMap showFlags_;
    private BasicObservable observable_;

    public VerbosityConfig() {
        this(null);
    }

    public VerbosityConfig(TreeMap showFlags) {
        if (showFlags == null) {
            showFlags = new TreeMap();
        }
        this.showFlags_ = showFlags;
        this.observable_ = new BasicObservable();
    }

    public void setShowFlag(String key, boolean showFlag) {
        this.showFlags_.put(key, new Boolean(showFlag));
        this.notifyObservers(null);
    }

    public TreeMap getShowFlagsMap() {
        return new TreeMap(this.showFlags_);
    }

    public boolean getShowFlag(String key) {
        Object obj = this.showFlags_.get(key);
        if (obj != null) {
            Boolean boolObj = (Boolean)obj;
            return boolObj;
        }
        LogUtil.logErr("VbCfg.Could not find key: " + key);
        return false;
    }

    public ArrayList getShowKeys() {
        return new ArrayList(this.showFlags_.keySet());
    }

    public static String getClassName() {
        return "VerbosityConfig";
    }

    @Override
    public String getMapName() {
        return VerbosityConfig.getClassName();
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public VerbosityConfig duplicate() {
        return new VerbosityConfig(this.cloneFlags());
    }

    @Override
    public String getName() {
        return VerbosityConfig.getClassName();
    }

    protected TreeMap cloneFlags() {
        TreeMap<String, Boolean> newMap = new TreeMap<String, Boolean>();
        for (String key : this.showFlags_.keySet()) {
            newMap.put(key, new Boolean((Boolean)this.showFlags_.get(key)));
        }
        return newMap;
    }

    @Override
    public void setName(String newName) {
        StrHelper.throwProgExcept("VerbosityConfig.setName() not implemented.");
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

