/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core;

import com.harrand.coreclasses.display.IFontDependent;
import com.harrand.coreclasses.display.StandardFontTheme;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.dirty.IDirtyTrackable;
import com.harrand.coreclasses.notification.dirty.IDirtyTracker;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.sketch.core.VerbosityConfig;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.linkStrategies.OffsetDirect;
import com.harrand.sketch.linkStrategies.right_angle.RightAngleStrategy;
import com.harrand.sketch.relation.joint.JointDimensionCalc;
import java.awt.Dimension;
import java.awt.Font;

public final class RenderConfig
implements IObservable,
IObserver,
Identifiable,
IDirtyTrackable {
    private Zoom zoom_;
    private LinkStrategy linkStrategy_;
    private VerbosityConfig verbosity_;
    private Font font_ = null;
    private Font headerFont_ = null;
    private final JointDimensionCalc jntDimCalc = new JointDimensionCalc(1.0);
    private double scaleFactor_ = 1.0;
    private int lineHeight;
    private boolean clickActionsOn = true;
    private BasicObservable observable_ = new BasicObservable();
    private IDirtyTracker dirtyTracker_;

    public RenderConfig(double zoom) {
        this(zoom, RenderConfig.getDefaultLinkStrategy(), RenderConfig.getDefaultVerbosity());
    }

    public RenderConfig(double zoom, LinkStrategy linkStrategy, VerbosityConfig verbosity) {
        this(new Zoom(zoom), linkStrategy, verbosity);
    }

    public RenderConfig(Zoom zoom, LinkStrategy linkStrategy, VerbosityConfig verbosity) {
        this.zoom_ = zoom;
        this.linkStrategy_ = linkStrategy;
        this.set(verbosity);
        this.setFont(StandardFontTheme.getStandardFont());
    }

    public static RenderConfig getDefaultConfig() {
        return new RenderConfig(RenderConfig.getDefaultZoom(), RenderConfig.getDefaultLinkStrategy(), RenderConfig.getDefaultVerbosity());
    }

    public boolean getClickActionsOn() {
        return this.clickActionsOn;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderConfig)) {
            return false;
        }
        RenderConfig other = (RenderConfig)o;
        if (other.getZoomLevel() != this.getZoomLevel()) {
            return false;
        }
        if (this.isFontDifferent(other)) {
            return false;
        }
        if (this.isVerbosityDifferent(other)) {
            return false;
        }
        if (this.getClickActionsOn() == other.getClickActionsOn()) {
            return false;
        }
        return this.linkStrategy_.getName().equals(other.getLinkStrategy().getName());
    }

    private boolean isFontDifferent(RenderConfig otherRc) {
        return !this.getFont().equals(otherRc.getFont());
    }

    private boolean isVerbosityDifferent(RenderConfig otherRc) {
        VerbosityConfig otherVb;
        VerbosityConfig thisVb = this.getVerbosityConfig();
        return !thisVb.equals(otherVb = otherRc.getVerbosityConfig());
    }

    public void set(Identifiable idf) {
        String className = idf.getMapName();
        if (className.equals(VerbosityConfig.getClassName())) {
            this.verbosity_ = (VerbosityConfig)idf;
        }
        if (className.equals(Zoom.getClassName())) {
            this.zoom_ = (Zoom)idf;
        }
        this.notifyDirty();
        this.notifyObservers(new UpdateChain(idf));
    }

    public void setLinkStrategy(LinkStrategy linkStrategy) {
        this.linkStrategy_ = linkStrategy;
        this.updateStrategyFont();
        this.notifyObservers(new UpdateChain(linkStrategy));
    }

    public void setClickActionsOn(boolean clickActionsOn) {
        this.clickActionsOn = clickActionsOn;
        this.notifyObservers(new UpdateChain(this));
    }

    @Override
    public void setName(String newName) {
        StrHelper.throwProgExcept("RenderConfig.setName() not implemented.");
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    private void updateScaleFactor() {
        this.jntDimCalc.setFontScaleFactor(RenderConfig.calcScaleFactor(this.font_));
    }

    public void setFont(Font font) {
        this.font_ = font;
        int fontSize = this.font_.getSize();
        this.headerFont_ = new Font(this.font_.getFamily(), 1, fontSize);
        this.updateScaleFactor();
        this.updateStrategyFont();
        this.lineHeight = GuiHelper.getFontLineHeight(this.font_);
    }

    public static double calcScaleFactor(Font font) {
        return StandardFontTheme.getScaleFactor(font);
    }

    public Dimension getJointSize() {
        return new Dimension((int)this.jntDimCalc.getLength(), (int)this.jntDimCalc.getHeight());
    }

    private void updateStrategyFont() {
        if (this.linkStrategy_ instanceof IFontDependent) {
            ((IFontDependent)((Object)this.linkStrategy_)).setFont(this.font_);
        }
    }

    public boolean isRightAngleLinkStrategy() {
        String rightAngletrategyClassName;
        String linkStrategyClassName = this.getLinkStrategy().getClass().getSimpleName();
        return linkStrategyClassName.equals(rightAngletrategyClassName = RightAngleStrategy.class.getSimpleName());
    }

    @Override
    public String getName() {
        return RenderConfig.getClassName();
    }

    public static String getClassName() {
        return "RenderConfig";
    }

    @Override
    public String getMapName() {
        return RenderConfig.getClassName();
    }

    public Zoom getZoom() {
        return this.zoom_;
    }

    public LinkStrategy getLinkStrategy() {
        return this.linkStrategy_;
    }

    public VerbosityConfig getVerbosityConfig() {
        return this.verbosity_;
    }

    private static Zoom getDefaultZoom() {
        return new Zoom(1.0);
    }

    private static LinkStrategy getDefaultLinkStrategy() {
        return new OffsetDirect();
    }

    private static VerbosityConfig getDefaultVerbosity() {
        return new VerbosityConfig();
    }

    public Font getFont() {
        return this.font_;
    }

    public Font getHeaderFont() {
        return this.headerFont_;
    }

    public double getScaleFactor() {
        return this.scaleFactor_;
    }

    public double getZoomLevel() {
        return this.zoom_.getLevel();
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public JointDimensionCalc getJointDimensionCalc() {
        return this.jntDimCalc;
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void update(UpdateChain chain) {
        this.notifyObservers(chain);
    }

    @Override
    public void setDirtyTracker(IDirtyTracker tracker) {
        this.dirtyTracker_ = tracker;
    }

    private void notifyDirty() {
        if (this.dirtyTracker_ != null) {
            this.dirtyTracker_.notifyDirty(this);
        }
    }
}

