/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core;

import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.IDiagramSrv;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class GlyphLocator {
    private IDiagramSrv diagramSrv_;
    public static final String HORZ = "Horz";
    public static final String VERT = "Vert";
    public static final int EDGE_BUFFER = 10;

    public GlyphLocator(IDiagramSrv diagramSrv) {
        this.diagramSrv_ = diagramSrv;
    }

    public Diagram getContainingDiagram(String glyphNm, Diagram currentDiagram) {
        Diagram containingDiagram = null;
        if (currentDiagram != null && currentDiagram.hasGlyph(glyphNm)) {
            containingDiagram = currentDiagram;
        } else {
            boolean found = false;
            Iterator it = this.diagramSrv_.getDiagrams().iterator();
            while (it.hasNext() && !found) {
                Diagram diagram = (Diagram)it.next();
                if (!diagram.hasGlyph(glyphNm)) continue;
                containingDiagram = diagram;
                found = true;
            }
        }
        return containingDiagram;
    }

    public Point getViewPosition(Glyph glyph, Diagram diagram, Dimension viewportSize) {
        double zoomLevel = diagram.getZoom().getLevel();
        Rectangle2D diagramRect = Zoomer.zoom(diagram.getBounds2D(), zoomLevel);
        Rectangle2D glyphRect = Zoomer.zoom(glyph.getBounds2D(), zoomLevel);
        Point glyphCenter = new Point((int)glyphRect.getCenterX(), (int)glyphRect.getCenterY());
        Point glyphOrigin = new Point((int)glyphRect.getX(), (int)glyphRect.getY());
        int margin = (int)(zoomLevel * 200.0);
        int maxX = (int)diagramRect.getWidth() - viewportSize.width + 10;
        int maxY = (int)diagramRect.getHeight() - viewportSize.height + 10;
        maxX = Math.max(maxX, 0);
        maxY = Math.max(maxY, 0);
        double newDoubleX = (int)glyphRect.getWidth() > viewportSize.width ? (double)(glyphOrigin.x - 10) : (double)glyphCenter.x - 0.5 * (double)viewportSize.width;
        double newDoubleY = (int)glyphRect.getHeight() > viewportSize.height ? (double)(glyphOrigin.y - 10) : (double)glyphCenter.y - 0.5 * (double)viewportSize.height;
        int newX = Math.max(0, (int)newDoubleX);
        int newY = Math.max(0, (int)newDoubleY);
        newX = Math.min(maxX, newX);
        newY = Math.min(maxY, newY);
        return new Point(newX, newY);
    }
}

