/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core;

import com.harrand.coreclasses.display.BasicColorable;
import com.harrand.coreclasses.display.IColorable;
import com.harrand.coreclasses.element.IDiagramCopyable;
import com.harrand.coreclasses.notification.dirty.IDirtyTrackable;
import com.harrand.coreclasses.notification.dirty.IDirtyTracker;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.diagram.hilight.color.IColorScheme;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.config.rc.IRenderConfigSrc;
import com.harrand.sketch.core.helper.RectangleHelper;
import com.harrand.sketch.glyph.RectGlyph;
import com.harrand.sketch.glyph.footer.FooterGlyph;
import com.harrand.sketch.interfaces.IHilightableGlyph;
import com.harrand.sketch.interfaces.IPreImagedGlyph;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.j2d.highLight.RoundRectHighLighter;
import com.harrand.sketch.support.DrawableUtil;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class GlyphBox
implements Glyph,
IDirtyTrackable,
IRenderConfigSrc,
IColorable,
IPreImagedGlyph,
IHilightableGlyph,
IDiagramCopyable,
IDrawable {
    private String name_;
    private BufferedImage img_;
    private Rectangle boxRect_;
    private Rectangle imgRect_;
    private final Color DEFAULT_COLOR = Color.BLUE;
    private final IColorable colorable_ = new BasicColorable(this.DEFAULT_COLOR);
    private RenderConfig rc_ = new RenderConfig(1.0);
    private final RoundRectHighLighter hiLighter = new RoundRectHighLighter();
    private List addedShapes_ = new ArrayList();
    private int cornerRadius_ = 0;
    private double cornerRadiusD_ = 0.0;
    private RoundRectangle2D roundRectAbs = new RoundRectangle2D.Double();
    private RoundRectangle2D roundRectRelative = new RoundRectangle2D.Double();
    private boolean selected_;
    private IDirtyTracker dirtyTracker_;
    private FooterGlyph footer = null;
    private boolean useGradient_ = true;
    private boolean shadingFlag_ = true;
    private int shadingWidth_ = 3;

    public GlyphBox() {
        this.setBoxRect(0, 0, 100, 50);
    }

    public GlyphBox(Rectangle boxRect, int cornerRadius) {
        this.setCornerRadius(cornerRadius);
        this.setBoxRect(boxRect.x, boxRect.y, boxRect.width, boxRect.height);
    }

    public GlyphBox(Point center, boolean useFooter) {
        int length = 10;
        int halfLength = (int)Math.round(0.5 * (double)length);
        Point start = new Point(center.x - halfLength, center.y - halfLength);
        this.setColor("MainBox", this.DEFAULT_COLOR);
        this.setBoxRect(start.x, start.y, length, length);
        this.setUseFooter(useFooter);
    }

    public void setBoxRect(int x, int y, int width, int height) {
        Rectangle newRect = new Rectangle(x, y, width, height);
        boolean isSameSize = this.boxRect_ != null ? RectangleHelper.isRectSameSize(this.boxRect_, newRect) : false;
        this.boxRect_ = newRect;
        this.roundRectAbs = new RoundRectangle2D.Double(x, y, this.getRoundRectWidth(), this.getRoundRectHeight(), this.cornerRadiusD_, this.cornerRadiusD_);
        this.roundRectRelative = new RoundRectangle2D.Double(0.0, 0.0, this.getRoundRectWidth(), this.getRoundRectHeight(), this.cornerRadiusD_, this.cornerRadiusD_);
        if (!isSameSize) {
            this.refresh();
        }
    }

    public void setUseGradient(boolean flag) {
        this.useGradient_ = flag;
    }

    private Point getOrigin() {
        return this.boxRect_.getLocation();
    }

    private void setUseFooter(boolean use) {
        if (use) {
            this.createFooter();
        } else {
            this.footer = null;
        }
    }

    public void setAddedShapes(List addedShapes) {
        this.addedShapes_ = new ArrayList(addedShapes);
        this.refresh();
    }

    private List getAddedShapes() {
        return new ArrayList(this.addedShapes_);
    }

    public void setRenderConfig(RenderConfig rc) {
        this.rc_ = rc;
    }

    public void setShadingWidth(int width) {
        this.shadingWidth_ = width;
    }

    public void setShadingFlag(boolean flag) {
        this.shadingFlag_ = flag;
    }

    public int getCornerRadius() {
        return this.cornerRadius_;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.boxRect_.contains(p);
    }

    public void setCornerRadius(int radius) {
        this.cornerRadius_ = radius;
        this.cornerRadiusD_ = radius;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.boxRect_.getBounds2D();
    }

    public Rectangle getBounds() {
        return this.boxRect_.getBounds();
    }

    private RectGlyph getRectGlyph() {
        RectGlyph rectGlyph = new RectGlyph(this.getRoundRectRelative());
        rectGlyph.setBgColor(this.colorable_.getColor("MainBox"));
        rectGlyph.setUseGradient(this.useGradient_);
        rectGlyph.setCoordSpace(this.getOrigin());
        if (this.hasFooter()) {
            rectGlyph.setFooter(this.footer);
        }
        return rectGlyph;
    }

    public void refresh() {
        this.calcImageSize();
        if (this.hasFooter()) {
            this.refreshFooter();
        }
        this.renderImage();
    }

    private void createImage() {
        this.calcImageSize();
        if (this.imgRect_.width > 0 && this.imgRect_.height > 0) {
            this.img_ = GuiHelper.getBufferedImage(this.imgRect_.width, this.imgRect_.height, true);
        }
    }

    @Override
    public BufferedImage getImage() {
        if (this.img_ == null) {
            this.createImage();
            this.refresh();
        }
        return this.img_;
    }

    private void renderImage() throws IllegalArgumentException {
        if (this.img_ != null) {
            if (this.needNewImage()) {
                this.createImage();
            }
            Graphics2D gfx = (Graphics2D)this.img_.getGraphics();
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gfx.setPaint(Color.BLACK);
            DrawableUtil.drawMixedItems(this.getDrawables(), gfx, this.rc_.getZoom());
        }
    }

    private boolean needNewImage() {
        boolean need = false;
        if (this.img_ != null && (this.img_.getWidth() != this.imgRect_.width || this.img_.getHeight() != this.imgRect_.height)) {
            need = true;
        }
        return need;
    }

    private void calcImageSize() {
        int shadingWidth = this.shadingFlag_ ? this.shadingWidth_ : 0;
        int width = this.boxRect_.width + shadingWidth;
        int height = this.boxRect_.height + shadingWidth;
        this.imgRect_ = new Rectangle(width, height);
        if (this.hasFooter()) {
            this.footer.setWidth(width);
        }
    }

    private boolean hasFooter() {
        return this.footer != null;
    }

    private void createFooter() {
        this.footer = new FooterGlyph(this, this.getBounds().width);
        this.refreshFooter();
    }

    private void refreshFooter() {
        int y = this.getBounds().height - this.footer.getHeight() - 2;
        this.footer.setOrigin(new Point(0, y));
        this.footer.setRadius(this.cornerRadius_);
    }

    public FooterGlyph getFooterGlyph() {
        return this.footer;
    }

    public List getDrawables() {
        ArrayList<RectGlyph> shapes = new ArrayList<RectGlyph>();
        shapes.add(this.getRectGlyph());
        shapes.addAll(this.getAddedShapes());
        return shapes;
    }

    @Override
    public void setAngle(double angle) {
    }

    @Override
    public void setName(String name) {
        this.name_ = name;
    }

    public static String getClassName() {
        return "GlyphBox";
    }

    @Override
    public String getName() {
        String nameOut = this.name_ != null ? this.name_ : "Box: " + this.getBounds().toString();
        return nameOut;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    public Element asXml() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(GlyphBox.getClassName());
        element.appendChild(XmlHelper.asXml(doc, this.boxRect_));
        XmlHelper.addElementSimple(doc, element, "CornerRadius", this.cornerRadius_);
        element.appendChild(XmlHelper.asXml(doc, this.getColor("MainBox")));
        return element;
    }

    public static GlyphBox fromXml(Element element) {
        Element elmRect = XmlHelper.getFirstElementByTagName(element, XmlHelper.getNameRectangle());
        int lCornerRadius = Integer.parseInt(XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, "CornerRadius")));
        Element elmColor = XmlHelper.getFirstElementByTagName(element, XmlHelper.getNameColor());
        GlyphBox box = new GlyphBox(XmlHelper.fromXmlRectangle(elmRect), lCornerRadius);
        box.setColor("MainBox", XmlHelper.fromXmlColor(elmColor));
        return box;
    }

    @Override
    public void move(Point p) {
        this.boxRect_.setLocation(p);
        this.notifyDirty();
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected_ = selected;
    }

    @Override
    public boolean getSelected() {
        return this.selected_;
    }

    @Override
    public void setScaleFactor(double scaleFactor) {
    }

    @Override
    public void setDirtyTracker(IDirtyTracker tracker) {
        this.dirtyTracker_ = tracker;
    }

    private void notifyDirty() {
        if (this.dirtyTracker_ != null) {
            this.dirtyTracker_.notifyDirty(this);
        }
    }

    @Override
    public void setColor(String key, Color color) {
        this.colorable_.setColor(key, color);
    }

    @Override
    public Color getColor(String key) {
        return this.colorable_.getColor(key);
    }

    @Override
    public List getKeys() {
        return this.colorable_.getKeys();
    }

    @Override
    public List<IDrawable> getHilightDrawables(Diagram diagram) {
        return this.hiLighter.getHilightShapes(this.getRoundRectAbs(), diagram.getZoom());
    }

    private RoundRectangle2D getRoundRectRelative() {
        return this.roundRectRelative;
    }

    private RoundRectangle2D getRoundRectAbs() {
        return this.roundRectAbs;
    }

    private long getRoundRectWidth() {
        return Math.round(this.boxRect_.getWidth()) - 1L;
    }

    private long getRoundRectHeight() {
        return Math.round(this.boxRect_.getHeight()) - 1L;
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        DrawableUtil.drawPreImaged(this, g2, zoom);
    }

    @Override
    public IDiagramCopyable copy(Diagram targetDiagram) {
        GlyphBox copy = new GlyphBox(this.boxRect_, this.cornerRadius_);
        copy.setName(this.name_);
        copy.setColor("MainBox", this.colorable_.getColor("MainBox"));
        return copy;
    }

    @Override
    public RenderConfig getRenderConfig() {
        return this.rc_;
    }

    @Override
    public void setColorScheme(IColorScheme colorScheme) {
        this.hiLighter.setColorScheme(colorScheme);
    }
}

