/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.element.IMemoryReclaimable;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.list.NamedList;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.INotifyMgr;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.dirty.IDirtyTrackable;
import com.harrand.coreclasses.notification.dirty.IDirtyTracker;
import com.harrand.coreclasses.zoom.IZoomable;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.command.IDeleteGlyphsCmdFactory;
import com.harrand.sketch.command.RemoveGlyphs;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.Lasso;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.config.rc.IRenderConfigSrc;
import com.harrand.sketch.glyph.ZoneGlyph;
import com.harrand.sketch.glyph.interfaces.IIdfGlyph;
import com.harrand.sketch.glyph.mgr.GlyphSelectionMgr;
import com.harrand.sketch.glyph.mgr.IGlyphSrc;
import com.harrand.sketch.interfaces.ILinkSource;
import com.harrand.sketch.interfaces.IRenderConfigDependent;
import com.harrand.sketch.j2d.DiagramPanel;
import com.harrand.sketch.j2d.mouse.DiagramMouseCtrl;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.object.DiagramCollector;
import com.harrand.sketch.object.Note;
import com.harrand.sketch.object.Zone;
import com.harrand.sketch.panel.IViewportSrc;
import com.harrand.sketch.relation.joint.JointDimensionCalc;
import com.harrand.sketch.support.DiagramSettingsTracker;
import com.harrand.sketch.support.GlyphResizeCtrl;
import com.harrand.sketch.xml.DiagramProps;
import com.harrand.sketch.zoom.ZoomCtrl;
import com.harrand.sketch.zoom.ZoomOriginStorage;
import com.harrand.util.LogUtil;
import com.harrand.util.MathUtil;
import com.harrand.util.Validator;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public final class Diagram
implements IObservable,
IObserver,
Identifiable,
Collector,
IZoomable,
IDirtyTracker,
IDirtyTrackable,
IGlyphSrc,
IRenderConfigSrc {
    private String name_;
    private RenderConfig rc_;
    private DiagramPanel diagramPanel_;
    private IViewportSrc viewportSrc_;
    private DiagramProps diagramProps_ = new DiagramProps();
    private ZoomCtrl zoomCtrl;
    private DiagramSettingsTracker settingsTracker_;
    private GlyphSelectionMgr selectionMgr;
    private IRefreshable nvPanel_;
    private BasicObservable observable_;
    private NamedList glyphs_ = new NamedList();
    private NamedList links_ = new NamedList();
    private ILinkSource linkSource_;
    private IDirtyTracker dirtyTracker_;
    private IDeleteGlyphsCmdFactory deleteGlyphsCmdfactory_;
    private DiagramCollector collector_;
    private DiagramMouseCtrl mouseCtrl;
    private ZoomOriginStorage zoomOriginStorage = new ZoomOriginStorage();
    private boolean needsRender_ = true;
    private long frameTimeStart_;
    private int frames_;
    private CommandChain cmdChain_;
    private boolean suppressPaint_;
    private boolean isRefreshing_;
    private Point lastMousePt;

    public Diagram(String name) {
        this(name, new RenderConfig(1.0), new ArrayList());
    }

    public Diagram(String name, RenderConfig config) {
        this(name, config, new ArrayList());
    }

    public Diagram(String name, RenderConfig config, List glyphs) {
        this.name_ = name;
        this.observable_ = new BasicObservable();
        this.settingsTracker_ = new DiagramSettingsTracker(this);
        this.collector_ = new DiagramCollector(this);
        this.selectionMgr = new GlyphSelectionMgr(this);
        this.mouseCtrl = new DiagramMouseCtrl(this);
        this.setRenderConfig(config);
        this.setGlyphs(glyphs);
        this.refresh();
        this.zoomCtrl = new ZoomCtrl(this);
        this.cmdChain_ = CommandChainMgr.getInstance().getCommandChain();
    }

    public void setDiagramPanel(DiagramPanel diagramPanel) {
        this.diagramPanel_ = diagramPanel;
        this.mouseCtrl.setIDiagramPanel(diagramPanel);
    }

    public void setDeleteGlyphsCmdFactory(IDeleteGlyphsCmdFactory factory) {
        this.deleteGlyphsCmdfactory_ = factory;
        this.selectionMgr.setDeleteGlyphsCmdFactory(factory);
    }

    public void setNotifyMgr(INotifyMgr notifyMgr) {
        this.collector_.setNotifyMgr(notifyMgr);
    }

    public double getScaleFactor() {
        return this.rc_.getScaleFactor();
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public boolean getNeedRender() {
        return this.needsRender_;
    }

    public void setNeedRender(boolean value) {
        this.needsRender_ = value;
    }

    public void setLinkSource(ILinkSource linkSource) {
        this.linkSource_ = linkSource;
        this.refresh();
    }

    public void setRenderConfig(RenderConfig config) {
        this.rc_ = config;
        this.rc_.setDirtyTracker(this);
        this.refresh();
    }

    public void updateLinkPositioners() {
        if (!this.rc_.isRightAngleLinkStrategy()) {
            for (Glyph link : this.getLinkGlyphs()) {
                if (!(link instanceof Link)) continue;
                ((Link)((Object)link)).setLinkPositioner(null);
            }
        }
    }

    public ZoomCtrl getZoomCtrl() {
        return this.zoomCtrl;
    }

    public DiagramCollector getCollector() {
        return this.collector_;
    }

    public DiagramMouseCtrl getMouseCtrl() {
        return this.mouseCtrl;
    }

    public void setSuppressPaint(boolean suppressPaint) {
        this.suppressPaint_ = suppressPaint;
    }

    public boolean getSuppressPaint() {
        return this.suppressPaint_;
    }

    public void setNvPanel(IRefreshable nvPanel) {
        this.nvPanel_ = nvPanel;
    }

    public void refresh() {
        this.isRefreshing_ = true;
        this.setNeedRender(true);
        boolean settingsChanged = this.settingsTracker_.isRefreshNeeded();
        if (settingsChanged) {
            this.refreshGlyphs();
            this.refreshLinks();
        }
        this.reloadLinks();
        this.calcLinks();
        this.refreshDiagramPanel();
        if (this.nvPanel_ != null) {
            this.nvPanel_.refresh();
        }
        this.setNeedRender(false);
        this.isRefreshing_ = false;
    }

    private Glyph getFirstSelectedGlyph(boolean includeLinks) {
        List glyphs = this.getSelectedGlyphs(includeLinks);
        Glyph firstGlyph = (Glyph)glyphs.get(0);
        return firstGlyph;
    }

    public void refreshDiagramPanel() {
        if (this.hasDiagramPanel()) {
            this.diagramPanel_.refresh();
        }
    }

    public void reloadLinks() {
        this.links_ = this.linkSource_ != null ? this.linkSource_.getLinks2(this) : new NamedList();
    }

    private void calcLinks() {
        Iterator it = this.links_.iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            link.setBoxes(this.glyphs_);
            if (!(link instanceof ForeignKeyGlyph)) continue;
            ((ForeignKeyGlyph)link).updateJoints();
        }
        LinkStrategy linkStrategy = this.rc_.getLinkStrategy();
        linkStrategy.setDiagram(this);
        this.links_ = linkStrategy.updateLinks(this.links_);
    }

    public static ITestResult checkValues(String name) {
        DataEntryResult result = new DataEntryResult(true);
        if (!Validator.isStringValid(name)) {
            result = new DataEntryResult(false, "Invalid Entry", "Diagram name can not be blank");
        }
        return result;
    }

    private void setGlyphs(List glyphs) {
        for (Glyph glyph : glyphs) {
            this.addGlyph(glyph);
        }
        this.updateLinksScaleFactor();
    }

    public Glyph getGlyph(String glyphNm) {
        Glyph foundGlyph = null;
        for (Glyph glyph : this.getGlyphsInSelectionOrder(false)) {
            if (foundGlyph != null || !glyphNm.equals(glyph.getName())) continue;
            foundGlyph = glyph;
        }
        return foundGlyph;
    }

    public Glyph getGlyphOrLink(String glyphNm) {
        Link link;
        Glyph glyph = this.getGlyph(glyphNm);
        if (glyph == null && (link = (Link)((Object)this.getLinksList().get(glyphNm))) != null) {
            glyph = (Glyph)((Object)link);
        }
        return glyph;
    }

    public Zone getZone(String nm) {
        return this.collector_.getZone(nm);
    }

    public List<Zone> getZones() {
        return this.collector_.getZones();
    }

    public List<Note> getNotes() {
        return this.collector_.getNotes();
    }

    public Note getNote(String nm) {
        return this.collector_.getNote(nm);
    }

    public DiagramPanel getDiagramPanel() {
        return this.diagramPanel_;
    }

    public void setGlyphsDirtyTracker(Glyph glyph) {
        if (glyph instanceof IDirtyTrackable) {
            ((IDirtyTrackable)((Object)glyph)).setDirtyTracker(this);
        }
    }

    private void updateLinksScaleFactor() {
        Iterator itLinks = this.getLinksList().iterator();
        while (itLinks.hasNext()) {
            Glyph linkGlyph = (Glyph)itLinks.next();
            linkGlyph.setScaleFactor(this.rc_.getScaleFactor());
        }
    }

    private void refreshGlyphs() {
        for (Glyph glyph : this.getOnlyGlyphs()) {
            this.refreshGlyph(glyph);
        }
        this.collector_.refreshGlyphs();
    }

    private void refreshGlyph(Glyph glyph) {
        if (glyph instanceof IRenderConfigDependent) {
            IRenderConfigDependent rcDependent = (IRenderConfigDependent)((Object)glyph);
            rcDependent.setDiagram(this);
            rcDependent.refresh();
            rcDependent.update(null);
        }
    }

    private void refreshLinks() {
        for (Glyph linkGlyph : this.getLinkGlyphs()) {
            if (!(linkGlyph instanceof IRefreshable)) continue;
            ((IRefreshable)((Object)linkGlyph)).refresh();
        }
    }

    public Rectangle getViewportRect() {
        Rectangle rect = null;
        if (this.viewportSrc_ != null) {
            rect = this.viewportSrc_.getViewportRect();
        }
        return rect;
    }

    public Point getVpCenterZoomed() {
        Rectangle vpRectZm = Zoomer.unZoom(this.getViewportRect(), this.getZoom());
        Point pt = MathUtil.getRectCenter(vpRectZm);
        return pt;
    }

    public void setViewportSrc(IViewportSrc vpSrc) {
        this.viewportSrc_ = vpSrc;
    }

    public static String getClassName() {
        return "Diagram";
    }

    @Override
    public String getMapName() {
        return Diagram.getClassName();
    }

    @Override
    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.getName();
    }

    public DiagramProps getDiagramProps() {
        return this.diagramProps_;
    }

    public void setDiagramProps(DiagramProps diagramProps) {
        this.diagramProps_ = diagramProps;
    }

    public List<Glyph> getOnlyGlyphs() {
        return this.getGlyphsInSelectionOrder(false);
    }

    public List<String> getGlyphNames() {
        ArrayList<String> glyphNms = new ArrayList<String>();
        for (Glyph glyph : this.getGlyphsInSelectionOrder(false)) {
            glyphNms.add(glyph.getName());
        }
        return glyphNms;
    }

    public boolean hasGlyph(String glyphNm) {
        ArrayList<String> glyphNms = new ArrayList<String>();
        glyphNms.addAll(this.getGlyphNames());
        glyphNms.addAll(this.getLinksList().getNames());
        glyphNms.addAll(this.getKeys("Zone"));
        glyphNms.addAll(this.getKeys("Note"));
        return glyphNms.contains(glyphNm);
    }

    public void initLinks(List links) {
        this.updateLinksScaleFactor();
        NamedList localList = new NamedList();
        for (Link link : links) {
            localList.add((INamed)((Object)link));
        }
        this.links_ = localList;
    }

    public Link getLink(String linkNm) {
        return (Link)((Object)this.links_.get(linkNm));
    }

    public TreeMap getLinksMap() {
        return null;
    }

    public List<Glyph> getLinkGlyphs() {
        ArrayList<Glyph> links = new ArrayList<Glyph>();
        Iterator it = this.getLinksList().iterator();
        while (it.hasNext()) {
            links.add((Glyph)it.next());
        }
        return links;
    }

    public ZoomOriginStorage getZoomOriginStorage() {
        return this.zoomOriginStorage;
    }

    public void setZoomOriginStorage(ZoomOriginStorage zoomOriginStorage) {
        this.zoomOriginStorage = zoomOriginStorage;
    }

    public NamedList getLinksList() {
        return this.links_;
    }

    public NamedList getGlyphsList() {
        return this.glyphs_;
    }

    public List getLinkNames() {
        return this.links_.getNames();
    }

    public Rectangle2D getBounds2D() {
        Rectangle2D bounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        for (Glyph glyph : this.getOnlyGlyphs()) {
            bounds = GeometryHelper.getMaxBounds(bounds, glyph.getBounds2D());
        }
        return bounds;
    }

    @Override
    public void setName(String name) {
        this.name_ = name;
        this.notifyObservers(null);
    }

    private void initAddedGlyph(Glyph glyph) {
        this.setGlyphsDirtyTracker(glyph);
        this.refreshGlyph(glyph);
    }

    public ITestResult addGlyph(Glyph glyph) {
        ITestResult addRslt = new DataEntryResult();
        if (glyph instanceof IIdfGlyph) {
            this.collector_.addGlyph(glyph);
        } else {
            this.initAddedGlyph(glyph);
            addRslt = this.glyphs_.add(glyph);
            if (addRslt.getPassed()) {
                this.notifyDirty(null);
            }
        }
        this.refresh();
        return addRslt;
    }

    public ITestResult initAddGlyphs(List glyphs) {
        ITestResult overAllRslt = new DataEntryResult();
        Glyph glyph2 = null;
        for (Glyph glyph2 : glyphs) {
            this.initAddedGlyph(glyph2);
            ITestResult rsltL = this.addGlyph(glyph2);
            if (rsltL.getPassed()) continue;
            overAllRslt = rsltL;
        }
        this.refresh();
        return overAllRslt;
    }

    public void removeGlyph(String glyphNm) {
        String[] parts = StrHelper.splitDotNote(glyphNm);
        if (this.isIIdfGlyph(parts[0])) {
            String partA = parts[0];
            String partB = parts[1];
            this.collector_.remove(partA, partB);
        } else {
            this.glyphs_.remove(glyphNm);
            this.notifyDirty(null);
        }
        this.refresh();
    }

    public void removeGlyphs(List glyphNms) {
        for (String glyphNm : glyphNms) {
            this.removeGlyph(glyphNm);
        }
        this.refresh();
    }

    public void removeGlyphs2(List<Glyph> glyphs) {
        ArrayList<String> glyphNms = new ArrayList<String>();
        for (Glyph glyph : glyphs) {
            glyphNms.add(glyph.getName());
        }
        this.removeGlyphs(glyphNms);
    }

    private boolean isIIdfGlyph(String firstPart) {
        boolean isIIdfGlyph = false;
        if (firstPart.equals(Note.getClassName()) || firstPart.equals(Zone.getClassName())) {
            isIIdfGlyph = true;
        }
        return isIIdfGlyph;
    }

    public void updateLinkNames(String oldDotNote, String newDotNote) {
        this.links_ = this.linkSource_.updateLinkNms(this, oldDotNote, newDotNote);
        this.refresh();
    }

    public void updateLinkNmsByPrefix(String oldDotNotePrefix, String newDotNotePrefix) {
        this.links_ = this.linkSource_.updateLinkNmsByPrefix(this, oldDotNotePrefix, newDotNotePrefix);
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseCtrl.mouseMoved(e);
    }

    public void mouseDragged(MouseEvent evt) {
        this.mouseCtrl.mouseDragged(evt);
    }

    public void mouseUp(MouseEvent evt) {
        this.mouseCtrl.mouseUp(evt);
        this.lastMousePt = evt.getPoint();
    }

    public CommandChain getCmdChain_() {
        return this.cmdChain_;
    }

    public Point getLastMousePt() {
        return this.lastMousePt;
    }

    public boolean isResizing() {
        return this.getResizeCtrl().isActive();
    }

    private GlyphResizeCtrl getResizeCtrl() {
        return this.mouseCtrl.getResizeCtrl();
    }

    private boolean hasDiagramPanel() {
        return this.diagramPanel_ != null;
    }

    public Point getDiagramPt(Point p) {
        return Zoomer.zoom(p, 1.0 / this.rc_.getZoomLevel());
    }

    public GlyphSelectionMgr getSelectionMgr() {
        return this.selectionMgr;
    }

    public ForeignKeyGlyph getSelectedForeignKeyGlyph() {
        return this.selectionMgr.getSelectedForeignKeyGlyph();
    }

    public ForeignKey getSelectedForeignKey() {
        return this.selectionMgr.getSelectedForeignKey();
    }

    public Table getSelectedTable() {
        return this.selectionMgr.getSelectedTable();
    }

    public DbTableGlyph getSelectedDbTableGlyph() {
        return this.selectionMgr.getSelectedDbTableGlyph();
    }

    public List getSelectedGlyphs(boolean includeLinks) {
        return this.selectionMgr.getSelectedGlyphs(includeLinks);
    }

    public void setSelectedGlyph(String glyphNm) {
        this.selectionMgr.setSelectedGlyph(glyphNm);
    }

    public void setSelectedGlyphs2(List<Glyph> glyphs) {
        this.selectionMgr.setSelectedGlyphs2(glyphs);
    }

    public List getAllGlyphs() {
        return this.getGlyphsInSelectionOrder(true);
    }

    public List<Glyph> getGlyphsInSelectionOrder(boolean includeLinks) {
        ArrayList<Glyph> all = new ArrayList<Glyph>();
        if (includeLinks) {
            all.addAll(this.getLinksList().asList());
        }
        all.addAll(this.glyphs_.asList());
        all.addAll(this.collector_.getNoteGlyphs());
        all.addAll(this.collector_.getZoneGlyphs());
        return all;
    }

    public List<Glyph> getGlyphsInRenderOrder(boolean includeLinks) {
        ArrayList<Glyph> all = new ArrayList<Glyph>();
        all.addAll(this.collector_.getZoneGlyphs());
        all.addAll(this.collector_.getNoteGlyphs());
        if (includeLinks) {
            all.addAll(this.getLinksList().asList());
        }
        all.addAll(this.glyphs_.asList());
        return all;
    }

    public void cancelDrag() {
        this.mouseCtrl.cancelDrag();
    }

    public void resizeGlyphDisp(Point mousePt) {
        Glyph firstGlyph = this.getFirstSelectedGlyph(false);
        this.getResizeCtrl().resizeGlyph(firstGlyph, mousePt, this.getZoom());
    }

    public Lasso getLasso() {
        return this.mouseCtrl.getLasso();
    }

    public void deleteSelected() {
        ArrayList<Glyph> selectedGlyphs = new ArrayList<Glyph>();
        for (Glyph glyph : this.getSelectedGlyphs(true)) {
            selectedGlyphs.add(glyph);
        }
        Command deleteCmd = null;
        if (this.deleteGlyphsCmdfactory_ != null) {
            deleteCmd = this.deleteGlyphsCmdfactory_.getDeleteCmd(this, selectedGlyphs);
        } else {
            LogUtil.logErr("Diagram.DeleteGlyphsCmdFactory is null.");
            int state = Command.getStateDo();
            deleteCmd = new RemoveGlyphs(this, selectedGlyphs, state);
        }
        deleteCmd.setCommandChain(this.cmdChain_);
        deleteCmd.actionPerformed(null);
    }

    public void selectAllGlyphs() {
        this.setSelectedGlyphs2(this.getOnlyGlyphs());
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void update(UpdateChain chain) {
        if (!this.isRefreshing_) {
            this.refresh();
            this.notifyObservers(chain);
        }
    }

    @Override
    public Zoom getZoom() {
        return this.rc_.getZoom();
    }

    @Override
    public void setZoom(Zoom zoom) {
        this.rc_.set(zoom);
        this.setNeedRender(true);
        this.refresh();
        this.notifyObservers(null);
    }

    @Override
    public void setDirtyTracker(IDirtyTracker tracker) {
        this.dirtyTracker_ = tracker;
        this.collector_.setDirtyTracker(tracker);
    }

    @Override
    public void notifyDirty(Object src) {
        if (this.dirtyTracker_ != null) {
            this.dirtyTracker_.notifyDirty(this);
        }
    }

    public void reclaimMemory() {
        for (Glyph obj : this.getOnlyGlyphs()) {
            if (!(obj instanceof IMemoryReclaimable)) continue;
            ((IMemoryReclaimable)((Object)obj)).reclaimMemory();
        }
    }

    @Override
    public RenderConfig getRenderConfig() {
        return this.rc_;
    }

    @Override
    public List<Glyph> getGlyphs(boolean includeLinks) {
        ArrayList<Glyph> all = new ArrayList<Glyph>();
        all.addAll(this.collector_.getZoneGlyphs());
        all.addAll(this.collector_.getNoteGlyphs());
        all.addAll(this.glyphs_.asList());
        if (includeLinks) {
            all.addAll(this.getLinksList().asList());
        }
        return all;
    }

    @Override
    public Glyph getGlyphContainingPoint(Point p) {
        Point diagramPt = this.getDiagramPt(p);
        Glyph selectedGlyph = null;
        List<Glyph> rectGlyphs = this.getGlyphsInSelectionOrder(true);
        ArrayList<Glyph> allGlyphs = new ArrayList<Glyph>(rectGlyphs);
        for (Glyph glyph : allGlyphs) {
            if (!glyph.contains(diagramPt)) continue;
            selectedGlyph = glyph;
            break;
        }
        return selectedGlyph;
    }

    public boolean isMouseOverGlyph(Point p) {
        Glyph glyph = this.getGlyphContainingPoint(p);
        return glyph != null;
    }

    public Link isPointOverLink(Point p) {
        List links = this.getLinksList().asList();
        for (Object object : links) {
            Glyph linkGlyph = (Glyph)object;
            if (!linkGlyph.contains(p)) continue;
            return (Link)((Object)linkGlyph);
        }
        return null;
    }

    public boolean isOverHighZLevelGlyph(Point p) {
        boolean isOverNonLinkGlyph = false;
        if (this.isMouseOverGlyph(p)) {
            Glyph glyph = this.getGlyphContainingPoint(p);
            boolean isLinkGlyph = glyph instanceof Link;
            boolean isZoneGlyph = glyph instanceof ZoneGlyph;
            if (!isLinkGlyph && !isZoneGlyph) {
                isOverNonLinkGlyph = true;
            }
        }
        return isOverNonLinkGlyph;
    }

    @Override
    public ITestResult add(Identifiable idf) {
        return this.collector_.add(idf);
    }

    @Override
    public ITestResult updateItem(Identifiable oldIdf, Identifiable newIdf) {
        return this.collector_.updateItem(oldIdf, newIdf);
    }

    @Override
    public void remove(String mapName, String identifiableName) {
        this.collector_.remove(mapName, identifiableName);
    }

    @Override
    public void rename(Identifiable idf, String oldName, String newName) {
        this.collector_.rename(idf, oldName, newName);
    }

    @Override
    public Identifiable get(String mapName, String identifiableName) {
        return this.collector_.get(mapName, identifiableName);
    }

    @Override
    public boolean contains(String mapName, String identifiableName) {
        return this.collector_.contains(mapName, identifiableName);
    }

    @Override
    public int size(String mapName) {
        return this.collector_.size(mapName);
    }

    @Override
    public List values(String mapName) {
        return this.collector_.values(mapName);
    }

    @Override
    public Set getKeys(String mapName) {
        return this.collector_.getKeys(mapName);
    }

    @Override
    public String getDisplayName(String mapName) {
        return this.collector_.getDisplayName(mapName);
    }

    @Override
    public String getDisplayPlural(String mapName) {
        return this.collector_.getDisplayPlural(mapName);
    }

    @Override
    public ITestResult checkDuplicateName(String mapNm, String newNm) {
        return this.collector_.checkDuplicateName(mapNm, newNm);
    }

    public JointDimensionCalc getJointDimensionCalc() {
        return this.rc_.getJointDimensionCalc();
    }
}

