/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core;

import com.harrand.coreclasses.element.Cardinality;
import com.harrand.coreclasses.geometry.positioningCoord.IPositioningCoord;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.list.NamedList;
import com.harrand.dbwrench.diagram.relation.notation.erNotation.DbwErNotationFactory;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.IJoint;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.linkStrategies.CenterDirect;
import com.harrand.sketch.linkStrategies.line.store.LinkCoordStore;
import com.harrand.sketch.linkStrategies.positioner.ILinkPositioner;
import com.harrand.sketch.relation.glyph.JointGlyph;
import com.harrand.sketch.relation.joint.JointDimensionCalc;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.notation.erNotation.IErNotation;
import com.harrand.sketch.relation.primitive.JointPrimitiveCalc;
import com.harrand.sketch.relation.rect.LinkRect;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class BasicLink
implements Link,
Glyph,
INamed {
    private String name_;
    private boolean selected_;
    private Collection<PositionableLine> lines_ = new ArrayList<PositionableLine>();
    private final TreeMap boxes_ = new TreeMap();
    private final TreeMap joints_ = new TreeMap();
    private String childBoxName_ = "";
    private String parentBoxName_ = "";
    private double scaleFactor_;
    private boolean isUserPositioned;
    public static final String PARENT_ID = "Parent";
    public static final String CHILD_ID = "Child";

    @Override
    public String getParentJointName() {
        return "ParentJoint";
    }

    @Override
    public String getChildJointName() {
        return "ChildJoint";
    }

    @Override
    public String getParentBoxName() {
        return this.parentBoxName_;
    }

    @Override
    public String getChildBoxName() {
        return this.childBoxName_;
    }

    public BasicLink(String name) {
        this.name_ = name;
        this.setJoints();
    }

    @Override
    public void setBoxes(NamedList glyphs) {
        Glyph childGlyph;
        Glyph parentGlyph;
        if (glyphs.size() > 0 && (parentGlyph = (Glyph)glyphs.get(0)) != null) {
            this.parentBoxName_ = parentGlyph.getName();
            this.boxes_.put(PARENT_ID, new LinkRect(parentGlyph.getBounds2D(), PARENT_ID));
        }
        if (glyphs.size() > 1 && (childGlyph = (Glyph)glyphs.get(1)) != null) {
            this.childBoxName_ = childGlyph.getName();
            this.boxes_.put(CHILD_ID, new LinkRect(childGlyph.getBounds2D(), CHILD_ID));
        }
    }

    private void setJoints() {
        IErNotation defaultNotation = DbwErNotationFactory.getInstance().getDefaultNotation();
        JointDimensionCalc jntDimCalc = new JointDimensionCalc(1.0);
        JointPrimitiveCalc jntPrimitiveCalc = new JointPrimitiveCalc(new Point2D.Double(0.0, 0.0), 0.0, jntDimCalc);
        JointGlyph jntParent = new JointGlyph(defaultNotation, jntPrimitiveCalc, new Cardinality(false, true, false), Color.BLACK, this.parentBoxName_, this.getName(), new CenterDirect(), false);
        this.joints_.put(this.getParentJointName(), jntParent);
        JointGlyph jntChild = new JointGlyph(defaultNotation, jntPrimitiveCalc, new Cardinality(true, true, true), Color.BLACK, this.childBoxName_, this.getName(), new CenterDirect(), false);
        this.joints_.put(this.getChildJointName(), jntChild);
    }

    public static String getClassName() {
        return "BasicLink";
    }

    public String getObjectName() {
        return this.name_;
    }

    @Override
    public boolean contains(Point2D p) {
        boolean found = false;
        Iterator it = this.joints_.values().iterator();
        while (it.hasNext() && !found) {
            found = ((Glyph)it.next()).contains(p);
        }
        if (!found) {
            found = this.isCloseBy(p);
        }
        return found;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    @Override
    public Rectangle2D getBounds2D() {
        Rectangle2D rectChild = this.getJoint(this.getChildJointName()).getBounds2D();
        Rectangle2D rectParent = this.getJoint(this.getParentJointName()).getBounds2D();
        double minX = Math.min(rectChild.getMinX(), rectParent.getMinX());
        double minY = Math.min(rectChild.getMinY(), rectParent.getMinY());
        double maxX = Math.max(rectChild.getMaxX(), rectParent.getMaxX());
        double maxY = Math.max(rectChild.getMaxY(), rectParent.getMaxY());
        return new Rectangle2D.Double(minX, minY, maxX, maxY);
    }

    @Override
    public LinkRect getBox(String key) {
        return (LinkRect)this.boxes_.get(key);
    }

    @Override
    public IJoint getJoint(String key) {
        return (IJoint)this.joints_.get(key);
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String name) {
        this.name_ = name;
    }

    public List<PositionableLine> getLines() {
        return new ArrayList<PositionableLine>(this.lines_);
    }

    @Override
    public boolean getIsSelfJoin() {
        return this.parentBoxName_.equalsIgnoreCase(this.childBoxName_);
    }

    @Override
    public boolean dependsOn(String key) {
        boolean depends = key.equals(this.parentBoxName_) || key.equals(this.childBoxName_);
        return depends;
    }

    public List getDrawables() {
        ArrayList<PositionableLine> shapes = new ArrayList<PositionableLine>(this.lines_);
        for (JointGlyph joint : this.joints_.values()) {
            shapes.addAll(joint.getDrawables());
        }
        return shapes;
    }

    public List getShapes() {
        return this.getDrawables();
    }

    private boolean isCloseBy(Point2D pt) {
        Point2D endParent;
        double DISTANCE_OK = 8.0;
        IJoint jtChild = this.getJoint(this.getChildJointName());
        IJoint jtParent = this.getJoint(this.getParentJointName());
        Point2D endChild = jtChild.getEndPoint();
        Line2D.Double mainLine = new Line2D.Double(endChild, endParent = jtParent.getEndPoint());
        double distance = mainLine.ptLineDist(pt);
        boolean nearLine = distance <= DISTANCE_OK;
        boolean withinBounds = this.getBounds2D().contains(pt.getX(), pt.getY());
        boolean isClose = nearLine && withinBounds;
        return isClose;
    }

    public List getSelectionShapes() {
        ArrayList selectionShapes = new ArrayList();
        IJoint joint = this.getJoint(this.getParentJointName());
        return selectionShapes;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void move(Point p) {
    }

    @Override
    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor_ = scaleFactor;
        Glyph joint = (Glyph)this.joints_.get(this.getChildJointName());
        joint.setScaleFactor(this.scaleFactor_);
        joint = (Glyph)this.joints_.get(this.getParentJointName());
        joint.setScaleFactor(this.scaleFactor_);
    }

    @Override
    public void setAngle(double angle) {
    }

    @Override
    public void rotateJoint(String key, double angle) {
        Glyph joint = (Glyph)this.joints_.get(key);
        joint.setAngle(angle);
    }

    @Override
    public void moveJoint(String key, Point2D p) {
        Glyph joint = (Glyph)this.joints_.get(key);
        joint.move(new Point((int)p.getX(), (int)p.getY()));
    }

    public void setShapes(List lines) {
        this.lines_ = lines;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected_ = selected;
    }

    @Override
    public boolean getSelected() {
        return this.selected_;
    }

    @Override
    public boolean requiredBoxGlyphPresent(Diagram diagram, String boxName) {
        boolean found = false;
        Iterator<Glyph> it = diagram.getOnlyGlyphs().iterator();
        while (it.hasNext() && !found) {
            Glyph obj = it.next();
            if (!(obj instanceof Glyph)) continue;
            Glyph glyph = obj;
            found = glyph.getName().equalsIgnoreCase(boxName);
        }
        return found;
    }

    @Override
    public void setNmPosCoord(IPositioningCoord nmPosCoord) {
    }

    public LinkCoordStore getLineStore() {
        return null;
    }

    @Override
    public void setIsUserPositioned(boolean isUserPositioned) {
        this.isUserPositioned = isUserPositioned;
    }

    @Override
    public boolean getIsUserPositioned() {
        return this.isUserPositioned;
    }

    @Override
    public void setLinkPositioner(ILinkPositioner linkPositioner) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ILinkPositioner getLinkPositioner() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void refresh() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

