/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.core;

import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.IDiagramSrv;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicDiagramSvr
implements IDiagramSrv {
    private Map diagrams_ = new HashMap();
    private BasicObservable observable_ = new BasicObservable();

    public BasicDiagramSvr(List diagrams) {
        for (Diagram diagram : diagrams) {
            this.diagrams_.put(diagram.getName(), diagram);
        }
    }

    @Override
    public Dimension getMaxSize() {
        int maxHeight = 0;
        int maxWidth = 0;
        for (Diagram diagram : this.getDiagrams()) {
            Rectangle2D rect = diagram.getBounds2D();
            maxHeight = Math.max(maxHeight, (int)rect.getHeight());
            maxWidth = Math.max(maxWidth, (int)rect.getWidth());
        }
        return new Dimension(maxWidth, maxHeight);
    }

    @Override
    public Diagram getDiagram(String diagramName) {
        return (Diagram)this.diagrams_.get(diagramName);
    }

    @Override
    public List getDiagrams() {
        return new ArrayList(this.diagrams_.values());
    }

    public void addDiagram(Diagram diagram) {
        this.diagrams_.put(diagram.getName(), diagram);
        this.notifyObservers(new UpdateChain(diagram));
    }

    public void removeDiagram(String diagramName) {
        this.diagrams_.remove(diagramName);
        this.notifyObservers(null);
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

