/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command.clickAction.draw;

import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.j2d.draw.IDrawable;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;

public final class HoverOverBtnDrawer {
    private RoundRectangle2D fullRect;
    private RoundRectangle2D topHalfRect;
    private String name = "HoverOverButton";
    private Collection<IDrawable> drawables = new ArrayList<IDrawable>();
    private Point2D origin;
    private double width;
    private double height;
    private EnhancedShape fillRectShape;
    private EnhancedShape outlineShape;
    private static int eshapeCount__ = 0;
    public static final int ROUND_RADIUS = 6;
    public static final Color FULL_RECT_COLOR = new Color(200, 216, 235);
    public static final Color TOP_HALF_COLOR = new Color(245, 248, 252);
    public static final Color OUTLINE_COLOR = new Color(170, 188, 213);

    private Collection<IDrawable> createDrawables() {
        this.drawables.clear();
        this.drawables.add(this.getRectFillShape(this.fullRect, FULL_RECT_COLOR));
        this.drawables.add(this.getRectFillShape(this.topHalfRect, TOP_HALF_COLOR));
        this.drawables.add(this.getOutlineShape());
        return this.drawables;
    }

    private void init(Point2D origin, double width, double height) {
        this.origin = origin;
        this.width = width;
        this.height = height;
        this.buildRects();
    }

    public Collection<IDrawable> getDrawables(Point2D origin, double width, double height) {
        this.init(origin, width, height);
        return this.createDrawables();
    }

    private EnhancedShape getOutlineShape() {
        if (this.outlineShape == null) {
            this.outlineShape = new EnhancedShape(this.fullRect, OUTLINE_COLOR);
            this.outlineShape.setIgnoreZoom(true);
        } else {
            this.outlineShape.setShape(this.fullRect);
        }
        return this.outlineShape;
    }

    private void buildRects() {
        this.buildFullRect();
        this.buildTopHalfRect();
    }

    private void buildFullRect() {
        this.fullRect = new RoundRectangle2D.Double(this.origin.getX(), this.origin.getY(), this.width - 1.0, this.height - 1.0, 6.0, 6.0);
    }

    private void buildTopHalfRect() {
        double halfHeight = this.height / 2.0;
        this.topHalfRect = new RoundRectangle2D.Double(this.origin.getX(), this.origin.getY(), this.width - 1.0, halfHeight, 6.0, 6.0);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private IDrawable getRectFillShape(RoundRectangle2D rect, Color color) {
        if (this.fillRectShape == null) {
            this.fillRectShape = new EnhancedShape(rect, color);
            ++eshapeCount__;
        }
        this.fillRectShape.setShape(rect);
        this.fillRectShape.setIsFilled(true);
        this.fillRectShape.setFillColor(color);
        this.fillRectShape.setIgnoreZoom(true);
        return this.fillRectShape;
    }
}

