/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command.clickAction.ctrl;

import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coregui.mouse.tracker.ClickActionMouseTracker;
import com.harrand.sketch.command.clickAction.action.ClickActionSizeCalc;
import com.harrand.sketch.command.clickAction.action.IClickAction;
import com.harrand.sketch.command.clickAction.bldr.IClickActionBldr;
import com.harrand.sketch.command.clickAction.ctrl.DiagramClickActionEnabler;
import com.harrand.sketch.command.clickAction.ctrl.IClickActionCtrl;
import com.harrand.sketch.command.clickAction.mouse.ClickActionMouseCalc;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.config.rc.IRenderConfigSrc;
import com.harrand.sketch.j2d.draw.IDrawable;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BasicClickActionCtrl
implements IClickActionCtrl {
    private boolean isActive;
    private Map<String, IClickAction> clickActionsMap = new HashMap<String, IClickAction>();
    private final IRefreshable refreshable;
    private ClickActionSizeCalc sizeCalc;
    private ClickActionMouseCalc mouseCalc;
    private Collection<IDrawable> drawables = new ArrayList<IDrawable>();
    private DiagramClickActionEnabler clickActionEnabler = new DiagramClickActionEnabler();
    private final Glyph glyph;
    private IRenderConfigSrc rcSrc;
    private IClickActionBldr clickActionBldr;
    private ClickActionMouseTracker mouseTracker;

    public BasicClickActionCtrl(IClickActionBldr clickActionBldr, Glyph glyph) {
        this.glyph = glyph;
        this.refreshable = (IRefreshable)((Object)glyph);
        this.rcSrc = (IRenderConfigSrc)((Object)glyph);
        this.clickActionBldr = clickActionBldr;
        this.isActive = true;
        this.initSizeCalc();
        this.initMouseCalc();
        this.initClickActionBldr();
        this.refresh();
        this.mouseTracker = new ClickActionMouseTracker(this);
    }

    private void initClickActionBldr() {
        this.clickActionBldr.setMouseCalc(this.mouseCalc);
        this.clickActionBldr.setSizeCalc(this.sizeCalc);
    }

    @Override
    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean getIsEnabled() {
        boolean isEnabled = this.clickActionEnabler.getAreClickActionsEnabled(this.rcSrc.getRenderConfig(), this.isActive);
        return isEnabled;
    }

    @Override
    public Collection<IDrawable> getDrawables() {
        this.drawables.clear();
        for (IClickAction clickAction : this.getClickActions()) {
            this.drawables.addAll(clickAction.getDrawables());
        }
        return this.drawables;
    }

    @Override
    public final void refresh() {
        if (this.getIsEnabled()) {
            this.clear();
            this.initSizeCalc();
            this.initMouseCalc();
            this.clickActionBldr.setSizeCalc(this.sizeCalc);
            this.clickActionBldr.setMouseCalc(this.mouseCalc);
            this.clickActionsMap = this.clickActionBldr.getClickActionsMap();
        }
    }

    @Override
    public void checkClearClickActions() {
        if (!this.clickActionsMap.isEmpty()) {
            this.clear();
            this.refreshable.refresh();
        }
    }

    @Override
    public Collection<IClickAction> getClickActions() {
        return this.clickActionsMap.values();
    }

    @Override
    public boolean mouseDown(MouseEvent e) {
        return this.mouseTracker.mouseDown(e);
    }

    private RenderConfig getRenderConfig() {
        return this.rcSrc.getRenderConfig();
    }

    private Font getFont() {
        return this.getRenderConfig().getFont();
    }

    private void initSizeCalc() {
        this.sizeCalc = new ClickActionSizeCalc(this.getFont());
        this.sizeCalc.setZoom(this.getRenderConfig().getZoom());
    }

    private void initMouseCalc() {
        Rectangle2D bounds = this.glyph.getBounds2D();
        Point2D.Double glyphOrigin = new Point2D.Double(bounds.getX(), bounds.getY());
        this.mouseCalc = new ClickActionMouseCalc(glyphOrigin, this.getRenderConfig().getZoom());
    }

    private void clear() {
        this.clickActionsMap.clear();
    }
}

