/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command.clickAction.bldr;

import com.harrand.sketch.command.clickAction.action.ClickActionSizeCalc;
import com.harrand.sketch.command.clickAction.action.IClickAction;
import com.harrand.sketch.command.clickAction.bldr.IClickActionBldr;
import com.harrand.sketch.command.clickAction.draw.ClickActionPosCalc;
import com.harrand.sketch.command.clickAction.mouse.ClickActionMouseCalc;
import com.harrand.sketch.command.clickAction.note.DeleteNoteClickAction;
import com.harrand.sketch.command.clickAction.note.EditNoteClickAction;
import com.harrand.sketch.glyph.GlyphPosUtil;
import com.harrand.sketch.glyph.NoteGlyph;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class NoteClickActionBldr
implements IClickActionBldr {
    private ClickActionSizeCalc sizeCalc;
    private ClickActionMouseCalc mouseCalc;
    private final NoteGlyph noteGlyph;
    private HashMap<String, IClickAction> CA_Map = new HashMap();
    private GlyphPosUtil posUtil = new GlyphPosUtil();
    private ClickActionPosCalc clickActionPosCalc = new ClickActionPosCalc();
    private EditNoteClickAction editClickAction;
    private DeleteNoteClickAction deleteClickAction;

    public NoteClickActionBldr(NoteGlyph noteGlyph) {
        this.noteGlyph = noteGlyph;
        this.posUtil.setRenderConfig(noteGlyph.getRenderConfig());
    }

    @Override
    public void setSizeCalc(ClickActionSizeCalc sizeCalc) {
        this.sizeCalc = sizeCalc;
    }

    @Override
    public void setMouseCalc(ClickActionMouseCalc mouseCalc) {
        this.mouseCalc = mouseCalc;
    }

    @Override
    public Map<String, IClickAction> getClickActionsMap() {
        this.CA_Map.clear();
        this.updateEditClickAction();
        this.updateDeleteClickAction();
        return this.CA_Map;
    }

    @Override
    public void clear() {
        this.editClickAction = null;
        this.deleteClickAction = null;
    }

    private void updateEditClickAction() {
        if (this.editClickAction == null) {
            this.editClickAction = new EditNoteClickAction(this.noteGlyph, this.sizeCalc, this.mouseCalc);
        }
        this.editClickAction.setMouseCalc(this.mouseCalc);
        Point2D topLeft = this.getNoteGlyphTopLeft();
        Point2D origin = this.clickActionPosCalc.getClickActionOriginFromGlyphImg(topLeft);
        this.editClickAction.setOrigin(origin);
        this.putClickAction(this.editClickAction);
    }

    private void updateDeleteClickAction() {
        if (this.deleteClickAction == null) {
            this.deleteClickAction = new DeleteNoteClickAction(this.noteGlyph, this.sizeCalc, this.mouseCalc);
        }
        this.deleteClickAction.setMouseCalc(this.mouseCalc);
        Point2D editTopLeft = this.getNoteGlyphTopLeft();
        int iconDrawWidth = this.posUtil.getIconSpace();
        Point2D.Double topLeft = new Point2D.Double(editTopLeft.getX() + (double)iconDrawWidth, editTopLeft.getY());
        Point2D origin = this.clickActionPosCalc.getClickActionOriginFromGlyphImg(topLeft);
        this.deleteClickAction.setOrigin(origin);
        this.putClickAction(this.deleteClickAction);
    }

    private void putClickAction(IClickAction clickAction) {
        this.CA_Map.put(clickAction.getName(), clickAction);
    }

    private Point2D getNoteGlyphTopLeft() {
        return this.noteGlyph.getLastTypeGlyphOrigin();
    }
}

