/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command.clickAction.action;

import com.harrand.coreclasses.display.StandardFontTheme;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.coregui.helper.GuiHelper;
import java.awt.Font;
import java.awt.geom.Rectangle2D;

public final class ClickActionSizeCalc {
    private final Font font;
    private final Font boldFont;
    private final Font enlargedBoldFont;
    private Zoom zoom = new Zoom(1.0);
    private final double scaleFactor;
    public static final int TEXT_SIDE_PAD = 3;

    public ClickActionSizeCalc(Font font) {
        this.font = font;
        this.boldFont = GuiHelper.getBoldFont(this.font);
        this.enlargedBoldFont = GuiHelper.getEnlargedBoldFont(this.font);
        this.scaleFactor = StandardFontTheme.getScaleFactor(this.font);
    }

    public Rectangle2D getButtonDrawRect(double x, double y) {
        double side = this.getHeight();
        Rectangle2D.Double rawRect = new Rectangle2D.Double(x, y, side, side);
        return rawRect;
    }

    private Rectangle2D zoomRect(Rectangle2D rawRect) {
        return Zoomer.zoom(rawRect, this.zoom.getLevel());
    }

    public Rectangle2D getTextDrawRect(String text, boolean isBold, boolean isEnlargedFont, double x, double y) {
        double width = this.getTextWidth(text, isBold, isEnlargedFont);
        double height = this.getHeight();
        Rectangle2D.Double rawRect = new Rectangle2D.Double(x, y, width, height);
        return rawRect;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setZoom(Zoom zoom) {
        this.zoom = zoom;
    }

    private double getHeight() {
        return GuiHelper.getSwingStringHeight(this.font);
    }

    private double getTextWidth(String text, boolean isBold, boolean isEnlargedFont) {
        Font fontA = isBold ? this.boldFont : this.font;
        Font fontB = isEnlargedFont ? this.enlargedBoldFont : fontA;
        double textWidth = GuiHelper.getSwingStringLength(text, fontB);
        double fullWidth = textWidth + 6.0;
        return fullWidth;
    }
}

