/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.command.Command;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.util.MathUtil;
import com.harrand.util.ResMgr;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class MoveGlyphs
extends Command {
    private final List glyphs_;
    private Map oldLocations_;
    private final int absMoveX_;
    private final int absMoveY_;
    private Zoom zoom_;
    private String name_;
    private Diagram diagram_;

    public MoveGlyphs(List glyphs, Zoom zoom, int zoomedMoveX, int zoomedMoveY) {
        this.zoom_ = zoom;
        double zoomLevel = this.zoom_.getLevel();
        this.absMoveX_ = (int)((double)zoomedMoveX / zoomLevel);
        this.absMoveY_ = (int)((double)zoomedMoveY / zoomLevel);
        this.glyphs_ = glyphs;
        this.setName();
        this.setProps();
        this.setOldLocations();
    }

    private MoveGlyphs(List glyphs, int absMoveX, int absMoveY, Map oldLocations) {
        this.glyphs_ = glyphs;
        this.oldLocations_ = oldLocations;
        this.absMoveX_ = absMoveX;
        this.absMoveY_ = absMoveY;
        this.setName();
        this.setProps();
    }

    public void setDiagram(Diagram diagram) {
        this.diagram_ = diagram;
    }

    public Map getOldLocations() {
        return this.oldLocations_;
    }

    public void setOldLocations(Map oldLocations) {
        this.oldLocations_ = oldLocations;
    }

    private void setOldLocations() {
        this.oldLocations_ = new TreeMap();
        for (Glyph glyph : this.glyphs_) {
            Rectangle2D bounds = glyph.getBounds2D();
            Point oldLocation = new Point((int)bounds.getX(), (int)bounds.getY());
            this.oldLocations_.put(glyph.getName(), oldLocation);
        }
    }

    private void setName() {
        this.name_ = ResMgr.getRes("glyph.move.label");
    }

    @Override
    public Command duplicate() {
        MoveGlyphs cmdNew = new MoveGlyphs(this.glyphs_, this.absMoveX_, this.absMoveY_, this.oldLocations_);
        cmdNew.setDiagram(this.diagram_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        for (Glyph glyph : this.glyphs_) {
            Point newLocation = new Point((Point)this.oldLocations_.get(glyph.getName()));
            newLocation.translate(this.absMoveX_, this.absMoveY_);
            Point safePt = this.getSafeLocation(newLocation);
            glyph.move(safePt);
        }
        if (this.diagram_ != null) {
            this.diagram_.refresh();
        }
    }

    private Point getSafeLocation(Point pt) {
        double rawX = pt.getX();
        double rawY = pt.getY();
        double safeX = pt.getX() < 0.0 ? 0.0 : rawX;
        double safeY = pt.getY() < 0.0 ? 0.0 : rawY;
        Point safePt = new Point(MathUtil.round(safeX), MathUtil.round(safeY));
        return safePt;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }

    @Override
    protected void undo() {
        for (Glyph glyph : this.glyphs_) {
            Point oldLocation = new Point((Point)this.oldLocations_.get(glyph.getName()));
            glyph.move(oldLocation);
        }
        if (this.diagram_ != null) {
            this.diagram_.refresh();
        }
    }
}

