/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command;

import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.j2d.DiagramExporter;
import com.harrand.sketch.j2d.draw.IDrawableOrderer;
import com.harrand.util.ResMgr;
import java.io.File;

public final class ExportDiagram
extends Command {
    private Diagram diagram_;
    private IFileUseMgr fileUseMgr_;
    private String formatName_;
    private File file_;
    private String name_;
    private IDrawableOrderer drawableOrderer;

    public ExportDiagram(Diagram diagram, IDrawableOrderer drawableOrderer, String formatName, File file, IFileUseMgr fileUseMgr) {
        this.diagram_ = diagram;
        this.formatName_ = formatName;
        this.file_ = file;
        this.fileUseMgr_ = fileUseMgr;
        this.drawableOrderer = drawableOrderer;
        this.setName();
        this.setProps();
    }

    private void setName() {
        if (this.formatName_.equals("jpg")) {
            this.name_ = ResMgr.getRes("image.export.jpeg.label");
        } else if (this.formatName_.equals("png")) {
            this.name_ = ResMgr.getRes("image.export.png.label");
        } else if (this.formatName_.equals("svg")) {
            this.name_ = "Export SVG";
        } else {
            StrHelper.throwProgExcept("Unknown formatName: " + this.formatName_);
        }
    }

    @Override
    public Command duplicate() {
        ExportDiagram cmdNew = new ExportDiagram(this.diagram_, this.drawableOrderer, this.formatName_, this.file_, this.fileUseMgr_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        try {
            DiagramExporter.export(this.diagram_, this.drawableOrderer, this.formatName_, this.file_);
            if (this.fileUseMgr_ != null) {
                String fileUseName = DiagramExporter.mapToFileUseName(this.formatName_);
                this.fileUseMgr_.addRecentFile(fileUseName, new File(this.file_.getPath()), true);
            }
        }
        catch (Exception e) {
            GuiMessageHelper.showGeneralAppErrMsg(null, e.getMessage());
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }

    @Override
    protected void undo() {
    }
}

