/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.command;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;

public final class AddGlyphToDiagram
extends Command {
    private String name_ = "Add Glyph";
    private Diagram diagram_;
    private Glyph glyph_;

    public AddGlyphToDiagram() {
        this.setProps();
    }

    public AddGlyphToDiagram(Diagram diagram, Glyph glyph, int state) {
        this.setState(state);
        this.diagram_ = diagram;
        this.glyph_ = glyph;
        this.name_ = this.name_ + ": " + glyph.getName();
        this.setProps();
    }

    @Override
    protected void setProps() {
        this.putValue("Name", this.getDoPrefix() + this.name_);
        this.putValue("ShortDescription", this.getDoPrefix() + "Add Glyph");
        this.putValue("LongDescription", this.getDoPrefix() + "Add Glyph to Diagram.");
        this.putValue("MnemonicKey", new Integer(71));
        this.putValue("SmallIcon", Icons.ADD);
    }

    @Override
    protected void undo() {
        this.diagram_.removeGlyph(this.glyph_.getName());
    }

    @Override
    protected void execute() {
        ITestResult rslt = this.diagram_.addGlyph(this.glyph_);
        if (!rslt.getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, rslt);
        }
    }

    @Override
    public Command duplicate() {
        AddGlyphToDiagram cmdNew = new AddGlyphToDiagram(this.diagram_, this.glyph_, this.getState());
        this.cloneCommon(cmdNew);
        return cmdNew;
    }
}

