/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.popup;

import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coregui.Icons;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchnb.action.diagram.LocateGlyphDisp;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.tree.node.TableNbNode;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.util.actions.Presenter;

public class InDiagramPopup
extends AbstractAction
implements Presenter.Popup {
    public static final String IN_DIAGRAM = "In Diagram";
    private TableNbNode node_;
    private int diagramCount_;

    public InDiagramPopup(TableNbNode node) {
        this.node_ = node;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NbUtil.logMsg("TableMenu is just a popup menu action.");
    }

    public JMenuItem getPopupPresenter() {
        return this.getInDiagramPopup();
    }

    public int getDiagramCount_() {
        return this.diagramCount_;
    }

    private JMenuItem getInDiagramPopup() {
        this.diagramCount_ = 0;
        JMenu subMenu = new JMenu(IN_DIAGRAM);
        subMenu.setToolTipText("Diagrams That Contain This Table");
        subMenu.setMnemonic(68);
        Database db = (Database)CentralLookup.getDefault().lookup(Database.class);
        CollectorIdf collIdf = (CollectorIdf)this.node_.getLookup().lookup(CollectorIdf.class);
        Table tbl = (Table)collIdf.getIdentifiable();
        String tblDotNote = tbl.getDotNote();
        for (Diagram diagram : db.values(Diagram.getClassName())) {
            Glyph glyph = diagram.getGlyph(tblDotNote);
            if (glyph == null) continue;
            LocateGlyphDisp action = new LocateGlyphDisp(diagram, tbl.getDotNote());
            JMenuItem diagramItem = new JMenuItem(action);
            diagramItem.setIcon(Icons.DIAGRAM);
            subMenu.add(diagramItem);
            ++this.diagramCount_;
        }
        if (this.diagramCount_ == 0) {
            subMenu.add(new JMenuItem("(None)"));
        }
        return subMenu;
    }
}

