/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.panel;

import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchnb.diagram.GlyphLocateMgr;
import com.harrand.dbwrenchnb.tree.node.NoteNbNode;
import com.harrand.dbwrenchnb.tree.node.TableNbNode;
import com.harrand.dbwrenchnb.tree.node.ZoneNbNode;
import com.harrand.sketch.object.Note;
import com.harrand.sketch.object.Zone;
import com.harrand.util.LogUtil;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;

public class myBTV
extends BeanTreeView {
    public myBTV() {
        this.addMouseListener();
    }

    private void addMouseListener() {
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                myBTV.this.checkFindableGlyph();
            }
        });
    }

    private void addKeyListener() {
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ExplorerManager mgr = ExplorerManager.find((Component)((Object)myBTV.this));
                String selectedNode = mgr.getSelectedNodes()[0].getDisplayName();
                String pressedKey = KeyEvent.getKeyText(e.getKeyCode());
                LogUtil.logMsg(selectedNode + " in myBtv.press: is being pressed by the " + pressedKey + " key!");
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ExplorerManager mgr = ExplorerManager.find((Component)((Object)myBTV.this));
                String selectedNode = mgr.getSelectedNodes()[0].getDisplayName();
                String pressedKey = KeyEvent.getKeyText(e.getKeyCode());
                LogUtil.logMsg(selectedNode + " in myBtv.release: is being pressed by the " + pressedKey + " key!");
            }
        });
    }

    private void checkFindableGlyph() {
        ExplorerManager mgr = ExplorerManager.find((Component)((Object)this));
        Node[] selectedNodes = mgr.getSelectedNodes();
        if (selectedNodes.length > 0) {
            AbstractNode node;
            CollectorIdf collIdf;
            Node selectedNode = selectedNodes[0];
            if (selectedNode instanceof TableNbNode) {
                TableNbNode tblNode = (TableNbNode)selectedNode;
                collIdf = (CollectorIdf)tblNode.getLookup().lookup(CollectorIdf.class);
                Table tbl = (Table)collIdf.getIdentifiable();
                this.getGlyphLocateMgr().locateGlyph(tbl.getDotNote());
            }
            if (selectedNode instanceof NoteNbNode) {
                node = (NoteNbNode)selectedNode;
                collIdf = (CollectorIdf)node.getLookup().lookup(CollectorIdf.class);
                Note note = (Note)collIdf.getIdentifiable();
                this.getGlyphLocateMgr().locateGlyph(note.getQN());
            }
            if (selectedNode instanceof ZoneNbNode) {
                node = (ZoneNbNode)selectedNode;
                collIdf = (CollectorIdf)node.getLookup().lookup(CollectorIdf.class);
                Zone zone = (Zone)collIdf.getIdentifiable();
                this.getGlyphLocateMgr().locateGlyph(zone.getQN());
            }
        }
    }

    private GlyphLocateMgr getGlyphLocateMgr() {
        return GlyphLocateMgr.getInstance();
    }
}

