/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.node;

import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.prompt.PromptDataEditDlg;
import com.harrand.dbwrench.command.provider.Nb8ActionBuilderProvider;
import com.harrand.dbwrench.object.ColumnSortPanelCtrl;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.sql.show.EShowSqlType;
import com.harrand.dbwrench.sql.show.IShowTableSqlActionBuilder;
import com.harrand.dbwrenchgui.command.PromptChangeSchema;
import com.harrand.dbwrenchgui.command.PromptRemoveTableCmd;
import com.harrand.dbwrenchgui.command.table.PromptCloneTable;
import com.harrand.dbwrenchgui.command.table.PromptTableDetails;
import com.harrand.dbwrenchgui.command.table.ShowTableDataTC;
import com.harrand.dbwrenchgui.panel.ColumnSortPanel;
import com.harrand.dbwrenchnb.tree.children.TableChildren;
import com.harrand.dbwrenchnb.tree.node.IdentifiableNodeBase;
import com.harrand.dbwrenchnb.tree.popup.InDiagramPopup;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class TableNbNode
extends IdentifiableNodeBase
implements IObserver {
    private final Table table;
    private final Schema schema;

    public TableNbNode(Schema schema, Table table) {
        super(new TableChildren(table), schema, table);
        this.table = table;
        this.schema = schema;
        this.table.addObserver(this);
        this.setDisplayName(table.getName());
        this.setIconBaseWithExtension("com/harrand/coregui/images/TblEc14.gif");
    }

    @Override
    public Action[] getSingleSelectionActions() {
        return new Action[]{this.getTableDetailsCmd(), this.getTableDataCmd(), this.getSortColCmd(), this.getCloneTableCmd(), this.getRemoveCmd(), this.getChangeSchemaCmd(), null, this.getShowSqlAction(EShowSqlType.CREATE), this.getShowSqlAction(EShowSqlType.INSERT), this.getShowSqlAction(EShowSqlType.UPDATE), this.getShowSqlAction(EShowSqlType.DELETE), null, new InDiagramPopup(this)};
    }

    @Override
    public Action getEditCmd() {
        return this.getTableDetailsCmd();
    }

    @Override
    public Identifiable getIdentifiable() {
        return this.table;
    }

    @Override
    public Collector getCollector() {
        return this.schema;
    }

    private AbstractAction getShowSqlAction(EShowSqlType showSqlType) {
        IShowTableSqlActionBuilder actionBuilder = Nb8ActionBuilderProvider.getInstance().getBuilder();
        return actionBuilder.buildAction(this.table, showSqlType);
    }

    private Command getRemoveCmd() {
        PromptRemoveTableCmd cmd = new PromptRemoveTableCmd(this.schema.getDb());
        cmd.setIdfDotNote(this.table.getDotNote());
        cmd.setShowWarning(true);
        return cmd;
    }

    public Transferable drag() throws IOException {
        return this.table;
    }

    private Action getSortColCmd() {
        Database db = this.schema.getDb();
        ColumnSortPanelCtrl ctrl = new ColumnSortPanelCtrl(db, this.table);
        ColumnSortPanel sortPanel = new ColumnSortPanel(ctrl);
        PromptDataEditDlg cmd = new PromptDataEditDlg(sortPanel);
        cmd.setName("Sort Columns");
        cmd.putValue("MnemonicKey", new Integer(83));
        return cmd;
    }

    private Action getChangeSchemaCmd() {
        ArrayList<Table> items = new ArrayList<Table>();
        items.add(this.table);
        PromptChangeSchema cmd = new PromptChangeSchema(this.schema.getDb(), items);
        return cmd;
    }

    @Override
    public void update(UpdateChain chain) {
        this.setDisplayName(this.table.getName());
    }

    private Action getCloneTableCmd() {
        PromptCloneTable cloneTableCommand = new PromptCloneTable(this.table, null);
        return cloneTableCommand;
    }

    private Action getTableDetailsCmd() {
        PromptTableDetails cmdL = new PromptTableDetails(this.table);
        return cmdL;
    }

    private Action getTableDataCmd() {
        ShowTableDataTC cmdL = new ShowTableDataTC(this.table);
        return cmdL;
    }
}

