/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.node;

import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.prompt.PromptCollectionUpdate;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrenchgui.panel.SequenceEditPanel;
import com.harrand.dbwrenchnb.tree.node.IdentifiableNodeBase;
import javax.swing.Action;

public class SequenceNbNode
extends IdentifiableNodeBase {
    private final Sequence sequence;
    private final Schema schema;

    public SequenceNbNode(Schema schema, Sequence sequence) {
        super(schema, sequence);
        this.sequence = sequence;
        this.schema = schema;
        this.setDisplayName(sequence.getName());
        this.setIconBaseWithExtension("com/harrand/coregui/images/sequence16.gif");
    }

    public Action getPreferredAction() {
        return this.getEditCmd();
    }

    @Override
    public Command getEditCmd() {
        SequenceEditPanel dataEditor = new SequenceEditPanel(this.sequence);
        return new PromptCollectionUpdate(this.schema, this.sequence, dataEditor);
    }

    @Override
    public Identifiable getIdentifiable() {
        return this.sequence;
    }

    @Override
    public Collector getCollector() {
        return this.schema;
    }
}

