/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.node;

import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.command.prompt.PromptCollectionUpdate;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrenchgui.command.RemoveSchCmd;
import com.harrand.dbwrenchgui.panel.SchemaEditPanel;
import com.harrand.dbwrenchnb.tree.children.SchemaChildren;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public class SchemaNbNode
extends AbstractNode
implements IObserver {
    private Schema schema_;
    private Database db_;

    public SchemaNbNode(Schema schema) {
        super((Children)new SchemaChildren(schema), Lookups.singleton((Object)new CollectorIdf(schema.getDb(), schema)));
        this.schema_ = schema;
        this.db_ = this.schema_.getDb();
        this.schema_.addObserver(this);
        this.setDisplayName(schema.getName());
        this.setIconBaseWithExtension("com/harrand/coregui/images/schema3.gif");
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{this.getEditCmd(), this.getRemoveCmd()};
    }

    public Action getPreferredAction() {
        return this.getEditCmd();
    }

    private Command getEditCmd() {
        SchemaEditPanel dataEditor = new SchemaEditPanel(this.schema_);
        return new PromptCollectionUpdate(this.db_, this.schema_, dataEditor);
    }

    private Command getRemoveCmd() {
        RemoveSchCmd removeCmd = new RemoveSchCmd(this.db_);
        removeCmd.setIdfDotNote(this.schema_.getName());
        removeCmd.setCommandChain(CommandChainMgr.getInstance().getCommandChain());
        return removeCmd;
    }

    @Override
    public void update(UpdateChain chain) {
        this.setDisplayName(this.schema_.getName());
    }
}

