/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.node;

import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coreclasses.element.IdentifiableGroup;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.prompt.PromptCollectionRemove;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrenchgui.command.PromptChangeSchema;
import com.harrand.dbwrenchnb.tree.node.IIdentifiableNode;
import com.harrand.dbwrenchnb.tree.node.action.RemoveManyAction;
import com.harrand.dbwrenchnb.tree.node.extract.NodeIdentifiableExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public abstract class IdentifiableNodeBase
extends AbstractNode
implements IIdentifiableNode {
    private final Identifiable identifiable;
    private final Schema schema;

    public IdentifiableNodeBase(Schema schema, Identifiable identifiable) {
        super(Children.LEAF, Lookups.singleton((Object)new CollectorIdf(schema, identifiable)));
        this.schema = schema;
        this.identifiable = identifiable;
    }

    public IdentifiableNodeBase(Children.Keys<Node> childrenKeys, Schema schema, Identifiable identifiable) {
        super(childrenKeys, Lookups.singleton((Object)new CollectorIdf(schema, identifiable)));
        this.schema = schema;
        this.identifiable = identifiable;
    }

    @Override
    public abstract Action getEditCmd();

    public Action[] getActions(boolean popup) {
        Collection<AbstractNode> selectedNodes = this.getSelectedNodes();
        if (selectedNodes.size() == 1) {
            return this.getSingleSelectionActions();
        }
        NodeIdentifiableExtractor extractor = new NodeIdentifiableExtractor();
        RemoveManyAction removeMany = (RemoveManyAction)SystemAction.get(RemoveManyAction.class);
        Map<Collector, IdentifiableGroup> identifiableGroupMap = extractor.extract(new ArrayList<AbstractNode>(selectedNodes));
        removeMany.setIdentifiableGroups(new ArrayList<IdentifiableGroup>(identifiableGroupMap.values()));
        removeMany.setDb(LookupUtil.findDb());
        return new Action[]{removeMany};
    }

    protected Collection<AbstractNode> getSelectedNodes() {
        Lookup.Result lookupResult = LookupUtil.createLookupResult(AbstractNode.class);
        Collection selectedNodes = lookupResult.allInstances();
        return selectedNodes;
    }

    @Override
    public Action[] getSingleSelectionActions() {
        return new Action[]{this.getEditCmd(), this.getRemoveCmd(), this.getChangeSchemaCmd()};
    }

    private Command getRemoveCmd() {
        return new PromptCollectionRemove(this.schema, this.identifiable);
    }

    private Action getChangeSchemaCmd() {
        ArrayList<Identifiable> items = new ArrayList<Identifiable>();
        items.add(this.identifiable);
        PromptChangeSchema cmd = new PromptChangeSchema(this.schema.getDb(), items);
        return cmd;
    }
}

