/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.node;

import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.prompt.PromptCollectionRemove;
import com.harrand.coregui.command.prompt.PromptCollectionUpdate;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrenchgui.command.PromptChangeSchema;
import com.harrand.dbwrenchgui.panel.CustomTypePanel;
import java.util.ArrayList;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public class CustomTypeNbNode
extends AbstractNode {
    private CustomType customType_;
    private Schema schema_;

    public CustomTypeNbNode(Schema schema, CustomType customType) {
        super(Children.LEAF, Lookups.singleton((Object)new CollectorIdf(schema, customType)));
        this.customType_ = customType;
        this.schema_ = schema;
        this.setDisplayName(customType.getName());
        this.setIconBaseWithExtension("com/harrand/coregui/images/custom_type16.png");
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{this.getEditCmd(), this.getRemoveCmd(), this.getChangeSchemaCmd()};
    }

    public Action getPreferredAction() {
        return this.getEditCmd();
    }

    private Command getEditCmd() {
        CustomTypePanel dataEditor = new CustomTypePanel(this.customType_, false);
        return new PromptCollectionUpdate(this.schema_, this.customType_, dataEditor);
    }

    private Command getRemoveCmd() {
        CustomTypeNbNode customTypeNbNode = this;
        return new PromptCollectionRemove(this.schema_, customTypeNbNode.customType_.getClassName(), this.customType_.getName());
    }

    private Action getChangeSchemaCmd() {
        ArrayList<CustomType> items = new ArrayList<CustomType>();
        items.add(this.customType_);
        PromptChangeSchema cmd = new PromptChangeSchema(this.schema_.getDb(), items);
        return cmd;
    }
}

