/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.folders.query;

import com.harrand.coreclasses.element.CollectorMapNm;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.dbwrench.db.name.DbDisplayNmSvr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrenchgui.command.DbwCmdFactory;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.tree.children.query.DbQueriesChildren;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public final class DbQueryFolderNode
extends AbstractNode
implements IObserver {
    private final Database db;
    private String displayNm;
    public static final String CLZ_NM = DbQuery.getClassName();

    public DbQueryFolderNode(Database db) {
        super((Children)new DbQueriesChildren(db), Lookups.singleton((Object)new CollectorMapNm(db, DbQuery.getClassName())));
        this.db = db;
        this.displayNm = new DbDisplayNmSvr().getDisplayPlural(CLZ_NM);
        this.db.addObserver(this);
        this.updateDisplayName();
        this.setIconBaseWithExtension(NbUtil.getFolderClosedImgPath());
    }

    private void updateDisplayName() {
        this.setDisplayName(StrHelper.getDisplayWithCount(this.displayNm, this.db.values(CLZ_NM)));
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{this.getAddCmd()};
    }

    private Command getAddCmd() {
        return DbwCmdFactory.getInstance().getAddQueryCmd(this.db);
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateDisplayName();
    }
}

