/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.folders;

import com.harrand.coreclasses.element.CollectorMapNm;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrenchgui.command.DbwCmdFactory;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.tree.children.DiagramsChildren;
import com.harrand.sketch.core.Diagram;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.lookup.Lookups;

public class DiagramFolderNode
extends AbstractNode
implements IObserver {
    private Database db_;
    private String displayNm_;

    public DiagramFolderNode(Database db, String displayNm) {
        super((Children)new DiagramsChildren(db), Lookups.singleton((Object)new CollectorMapNm(db, Diagram.getClassName())));
        this.db_ = db;
        this.displayNm_ = displayNm;
        this.db_.addObserver(this);
        this.updateDisplayName();
        this.setIconBaseWithExtension(NbUtil.getFolderClosedImgPath());
    }

    private void updateDisplayName() {
        this.setDisplayName(StrHelper.getDisplayWithCount(this.displayNm_, this.db_.getDiagrams()));
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{this.getAddCmd()};
    }

    private Command getAddCmd() {
        return DbwCmdFactory.getInstance().getAddDiagramCmd();
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateDisplayName();
    }
}

