/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.tree.children;

import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchnb.tree.folders.CustomTypeFolderNode;
import com.harrand.dbwrenchnb.tree.folders.ProcFolderNode;
import com.harrand.dbwrenchnb.tree.folders.SequenceFolderNode;
import com.harrand.dbwrenchnb.tree.folders.TableFolderNode;
import com.harrand.dbwrenchnb.tree.folders.ViewFolderNode;
import java.util.ArrayList;
import java.util.List;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class SchemaChildren
extends Children.Keys<Node> {
    private Schema schema_;
    private DbUser user_ = App.getUser();
    private IOptionMgr optMgr_ = null;

    public SchemaChildren(Schema schema) {
        this.schema_ = schema;
        this.optMgr_ = this.user_.getOptionMgr("db.explorer.option.mgr");
    }

    protected Node[] createNodes(Node key) {
        return new Node[]{key};
    }

    protected void addNotify() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(this.getTableFolderNode());
        nodes.add(this.getViewFolderNode());
        this.addOptionalFolder(nodes, this.getProcFolderNode(), "db.explorer.show.proc.folder", Proc.getClassName());
        this.addOptionalFolder(nodes, this.getSequenceFolderNode(), "db.explorer.show.sequence.folder", Sequence.getClassName());
        this.addOptionalFolder(nodes, this.getCustomTypeFolderNode(), "db.explorer.show.custom.type.folder", CustomType.getClassName());
        Object[] folderNodes = nodes.toArray(new Node[0]);
        this.setKeys(folderNodes);
    }

    private void addOptionalFolder(List<Node> nodes, Node nodeToAdd, String optKey, String mapNm) {
        boolean hasIdfs;
        int idfCount = this.schema_.size(mapNm);
        boolean bl = hasIdfs = idfCount > 0;
        if (hasIdfs || this.optMgr_.getBoolValue(optKey)) {
            nodes.add(nodeToAdd);
        }
    }

    private Node getTableFolderNode() {
        return new TableFolderNode(this.schema_);
    }

    private Node getViewFolderNode() {
        return new ViewFolderNode(this.schema_);
    }

    private Node getProcFolderNode() {
        return new ProcFolderNode(this.schema_);
    }

    private Node getSequenceFolderNode() {
        return new SequenceFolderNode(this.schema_);
    }

    private Node getCustomTypeFolderNode() {
        return new CustomTypeFolderNode(this.schema_);
    }
}

