/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.server.forward;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.implementation.BasicScript;
import com.harrand.coreclasses.interfaces.implementation.BasicStep;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.Icons;
import com.harrand.coregui.dialog.CloseDialog;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.script.JdbcScriptCtrl;
import com.harrand.dbwrench.script.ScriptMgr;
import com.harrand.dbwrench.script.TransactionCtrl;
import com.harrand.dbwrench.script.builder.DatabaseScriptBuilder;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.db.TransactionErrorPanel;
import com.harrand.dbwrenchgui.db.worker.meta.SqlScriptWorker;
import com.harrand.dbwrenchgui.sub.NbEditPanel;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.server.display.FadingStatusPanel;
import com.harrand.dbwrenchnb.server.forward.ForEngCtrl;
import com.harrand.dbwrenchnb.server.forward.ForEngLogger;
import com.harrand.dbwrenchnb.server.forward.IScriptClient;
import com.harrand.util.FileHelper;
import com.harrand.util.MathUtil;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ScriptViewerTopComponent
extends TopComponent
implements IObserver,
IScriptClient,
IThreadObserver {
    private NbEditPanel textPanel_ = new NbEditPanel(false);
    private ForEngCtrl forEngCtrl_ = ForEngCtrl.getInstance();
    private ScriptMgr scriptMgr_ = ScriptMgr.getInstance();
    private JdbcScriptCtrl scriptCtrl_ = new JdbcScriptCtrl();
    private ForEngLogger forEngLogger_;
    private final IScript emptyScript_;
    private IScript fullScript_ = this.emptyScript_ = DatabaseScriptBuilder.getEmptyScript();
    private IStep displayStep_ = this.emptyScript_;
    private FadingStatusPanel statusDisplayer = new FadingStatusPanel(0);
    private JButton btnRecalcScript_ = new JButton(ResMgr.getRes("recalculate.script.label"), Icons.SCRIPT_CALC);
    private JButton btnRun_ = new JButton("Run Script", Icons.START);
    private JButton btnToFile_ = new JButton(ResMgr.getRes("save.to.file"), Icons.SAVE_AS);
    private Database db_ = null;
    private JdbcConfig lastCfg_ = null;
    private DbUser user_ = App.getUser();
    private IFileUseMgr fileUseMgr_ = App.getFileUseMgr();
    private IOptionMgr forEngOptMgr_;
    private CentralLookup centralLookup_ = CentralLookup.getDefault();
    private ConnMgr connMgr_ = ConnMgr.getInstance();
    private File lastExportFile_;
    public static final String TITLE = "Script Viewer";
    public static final String RECALC_STR = "Recalculate";
    public static final String RUN_SCRIPT_STR = "Run Script";
    public static final String CANCEL_STR = "Cancel";
    public static final int RECALC_ID = 0;
    public static final int RUN_SCRIPT_ID = 1;
    public static final int CANCEL_ID = 2;
    private static ScriptViewerTopComponent instance;
    public static final String PREFERRED_ID = "ScriptViewerTopComponent";

    private ScriptViewerTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ScriptViewerTopComponent.class, (String)"CTL_ScriptViewerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ScriptViewerTopComponent.class, (String)"HINT_ScriptViewerTopComponent"));
        this.setDisplayName("Forward Engineer");
        this.buildControls();
        this.buildPanel();
        this.addListeners();
        this.setCosmetics();
        this.forEngLogger_ = ForEngLogger.getInstance();
        this.connMgr_.addObserver(this);
        this.centralLookup_.addObserver(this);
        this.scriptMgr_.addObserver(this);
        this.forEngCtrl_.addObserver(this);
        this.scriptCtrl_.addObserver(this);
        this.forEngLogger_.setScriptCtrl(this.scriptCtrl_);
        this.forEngOptMgr_ = this.user_.getOptionMgr("forward.engineer.option.mgr");
        this.forEngCtrl_.setStatusDisplayer(this.statusDisplayer);
        this.forEngCtrl_.setDisabledButton(this.btnRecalcScript_);
    }

    public void setDisplayStep(IStep step) {
        this.displayStep_ = step;
        String text = this.getStepText(step);
        this.textPanel_.setText(text);
    }

    public void setSingleStep(IStep step) {
        BasicStep newStep = new BasicStep(step.getName(), step.getExecuteObject().toString());
        if (step.getComment() != null) {
            newStep.setComment(step.getComment());
        }
        BasicScript wrapScript = new BasicScript(newStep.getName());
        wrapScript.add(newStep);
        this.setDisplayStep(wrapScript);
    }

    private void activateWindows() {
        NbUtil.openActivateTc("ScriptHierarchyTopComponent");
        this.requestActive();
    }

    private void setFullScript(IScript script) {
        this.fullScript_ = script;
        this.scriptMgr_.setFullScript(script);
    }

    private void checkConfigChanged() {
        JdbcConfig currentCfg = this.getConfig();
        if (!MathUtil.isEquivalent(currentCfg, this.lastCfg_)) {
            this.clear();
        }
    }

    private void checkDisplayStepChanged() {
        IStep newStep = this.scriptMgr_.getSelectedStep();
        if (!newStep.equals(this.displayStep_)) {
            this.setDisplayStep(newStep);
        }
    }

    private void checkDbChanged() {
        if (LookupUtil.hasDbChanged(this.db_)) {
            if (this.db_ != null) {
                this.db_.removeStructureTracker(this.scriptCtrl_);
            }
            this.clear();
        }
    }

    private void displayResultMsg(ITestResult calcResult) {
        if (!calcResult.getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, calcResult);
        }
    }

    private IScript getExecutableScript() {
        IScript script;
        if (this.displayStep_ instanceof IScript) {
            script = (IScript)this.displayStep_;
        } else {
            script = new BasicScript("containing script");
            script.setLogEntry("");
            script.add(this.displayStep_);
        }
        return script;
    }

    private String getStepText(IStep step) {
        String text = step instanceof IScript ? this.scriptCtrl_.asRunnableText((IScript)step) : step.getExecuteObject().toString() + ";";
        return text;
    }

    private void addListeners() {
        this.btnRecalcScript_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptViewerTopComponent.this.recalculate();
            }
        });
        this.btnRun_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptViewerTopComponent.this.execScript();
            }
        });
        this.btnToFile_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptViewerTopComponent.this.saveAsFile();
            }
        });
    }

    private void clear() {
        this.fullScript_ = DatabaseScriptBuilder.getEmptyScript();
        this.setDisplayStep(this.fullScript_);
    }

    private JdbcConfig getConfig() {
        return this.connMgr_.getCurrentCfg();
    }

    public void recalculate() {
        JdbcConfig config = this.getConfig();
        this.setFullScript(DatabaseScriptBuilder.getComparingScript());
        this.setDisplayStep(this.fullScript_);
        this.activateWindows();
        this.db_ = this.getLookupDb();
        this.db_.addStructureTracker(this.scriptCtrl_);
        this.forEngCtrl_.setDisabledButton(this.btnRecalcScript_);
        this.forEngCtrl_.startRecalculate(config, this, this.db_);
    }

    private void buildControls() {
        this.textPanel_.setEditable(false);
    }

    private void buildPanel() {
        this.layoutPanel();
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        int gap = 5;
        this.add(this.getHeaderPanel(), "North");
        this.add(this.getCenterPanel(), "Center");
    }

    private JPanel getHeaderPanel() {
        XpHeaderPanel header = new XpHeaderPanel("Forward Engineer Script", "Forward engineer database design changes to a server");
        return header;
    }

    private JPanel getCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.textPanel_, "Center");
        panel.add((Component)this.getSouthPanel(), "South");
        return panel;
    }

    private JPanel getSouthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JSeparator());
        panel.add(this.getBtnPanel());
        return panel;
    }

    private JPanel getBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.statusDisplayer);
        panel.add(Box.createGlue());
        panel.add(this.btnRecalcScript_);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.btnRun_);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.btnToFile_);
        Border border = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        panel.setBorder(border);
        return panel;
    }

    private Database getLookupDb() {
        return (Database)this.centralLookup_.lookup(Database.class);
    }

    private void setCosmetics() {
        this.setIcon(Icons.TO_SERVER.getImage());
        this.btnRun_.setToolTipText(ResMgr.getRes("tooltip.script.start"));
        this.btnToFile_.setToolTipText(ResMgr.getRes("save.script.to.file.tooltip"));
        this.btnRecalcScript_.setToolTipText(this.btnRecalcScript_.getText());
        this.btnRecalcScript_.setMnemonic(82);
        this.btnRun_.setMnemonic(83);
        this.btnToFile_.setMnemonic(70);
    }

    private void execScript() {
        JdbcConfig config = this.getConfig();
        if (config != null && config.isGeneric()) {
            String msg = StrHelper.getGenericCfgMsg("execute a script");
            GuiMessageHelper.showWarningMsg(null, "Forward Engineer", msg);
            return;
        }
        if (this.confirmStart()) {
            this.forEngLogger_.clear();
            config = ConnMgr.getInstance().getCurrentCfg();
            boolean useTxn = this.forEngOptMgr_ != null ? this.forEngOptMgr_.getBoolValue("forward.engineer.z.use.transactions") : false;
            this.scriptCtrl_.setUseTransaction(useTxn);
            IScript executableScript = this.getExecutableScript();
            SqlScriptWorker scriptWorker = new SqlScriptWorker();
            scriptWorker.setSvrStatusBar(this.statusDisplayer);
            scriptWorker.setDisabledButton(this.btnRun_);
            scriptWorker.startScript(config, this.scriptCtrl_, executableScript, this);
        }
    }

    private ITestResult checkRollback() {
        DataEntryResult result = new DataEntryResult(true, "Transaction Check OK");
        TransactionCtrl txnCtrl = this.scriptCtrl_.getTransactionCtrl();
        if (txnCtrl.getIsInRollback()) {
            this.showRollbackMsg(txnCtrl);
            result = new DataEntryResult(false, "Rollback Occured", "Rollback Occured");
        }
        return result;
    }

    private void showRollbackMsg(TransactionCtrl txnCtrl) {
        if (txnCtrl.getIsInRollback() && !txnCtrl.getUserAlerted()) {
            TransactionErrorPanel errPanel = new TransactionErrorPanel(txnCtrl.getErrMsg(), txnCtrl.getSqlStr());
            CloseDialog dlg = new CloseDialog(null, true, errPanel);
            dlg.setVisible(true);
            txnCtrl.setUserAlerted(true);
        }
    }

    private boolean confirmStart() {
        boolean yesHit;
        if (this.displayStep_.getName().equals(this.emptyScript_.getName())) {
            GuiMessageHelper.showWarningMsg(null, "No Script to Run", "No script has been generated. \nUse the Recalculate button to generate a script.");
            return false;
        }
        boolean wasExecOk = true;
        IScript script = this.getExecutableScript();
        ITestResult wasExecResult = this.forEngCtrl_.getWasExecuted(this.displayStep_);
        if (wasExecResult.getPassed() && !(yesHit = GuiMessageHelper.showYesNoMsgDefaultNo(null, wasExecResult.getSummary(), wasExecResult.getDetail()))) {
            wasExecOk = false;
        }
        if (!wasExecOk) {
            return false;
        }
        boolean dbModifiedOk = true;
        ITestResult dbModifiedResult = this.scriptCtrl_.getDbStuctureModified();
        if (dbModifiedResult.getPassed()) {
            int dbModifiedResponse = this.promptRecalc(dbModifiedResult);
            if (dbModifiedResponse == 0) {
                dbModifiedOk = false;
                this.recalculate();
            } else if (dbModifiedResponse == 2) {
                dbModifiedOk = false;
            }
        }
        if (!dbModifiedOk) {
            return false;
        }
        String warnBackupStr = this.forEngCtrl_.getBackupWarningStr(this.getConfig(), this.getExecutableScript(), this.db_.getName());
        String title = App.getRes("engineer.forward.confirm.title");
        boolean warnBackupOk = GuiMessageHelper.showYesNoMsg(null, title, warnBackupStr);
        return warnBackupOk;
    }

    private int promptRecalc(ITestResult inputResult) {
        Frame parentFrame = GuiMessageHelper.getDefaultParent();
        Object[] options = new Object[]{RECALC_STR, RUN_SCRIPT_STR, CANCEL_STR};
        int response = 2;
        try {
            response = JOptionPane.showOptionDialog(parentFrame, inputResult.getDetail(), inputResult.getSummary(), 1, 3, null, options, RECALC_STR);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    private void saveAsFile() {
        File defaultFile = null;
        defaultFile = this.lastExportFile_ != null ? this.lastExportFile_ : (this.fileUseMgr_ != null ? this.fileUseMgr_.getDefaultFile("SqlScript", null) : new File(""));
        File destFile = GuiMessageHelper.promptForSaveFile(defaultFile);
        if (destFile != null) {
            this.exportFile(destFile);
        }
    }

    public void exportFile(File destFile) {
        FileHelper.saveStringToFile(this.textPanel_.getText(), destFile);
        this.lastExportFile_ = destFile;
        this.fileUseMgr_.addRecentFile("SqlScript", this.lastExportFile_, true);
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasClassName(ConnMgr.class.getName())) {
            this.checkConfigChanged();
        }
        if (LookupUtil.isDbLookupUpdate(chain)) {
            this.checkDbChanged();
        }
        if (chain.hasClassName(ScriptMgr.class.getName())) {
            this.checkDisplayStepChanged();
        }
    }

    @Override
    public void threadDone(SwingWorker threadWorker) {
        if (this.checkRollback().getPassed()) {
            this.forEngCtrl_.checkDbSynced(this.getConfig(), this.db_);
            this.recalculate();
        }
        this.displayStep_.setWasExecuted(true);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized ScriptViewerTopComponent getDefault() {
        if (instance == null) {
            instance = new ScriptViewerTopComponent();
        }
        return instance;
    }

    public static synchronized ScriptViewerTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(ScriptViewerTopComponent.class.getName()).warning("Cannot find ScriptViewerTopComponent component. It will not be located properly in the window system.");
            return ScriptViewerTopComponent.getDefault();
        }
        if (win instanceof ScriptViewerTopComponent) {
            return (ScriptViewerTopComponent)win;
        }
        Logger.getLogger(ScriptViewerTopComponent.class.getName()).warning("There seem to be multiple components with the 'ScriptViewerTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ScriptViewerTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public String getDisplayName() {
        return TITLE;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    @Override
    public void setForEngScript(IScript newScript) {
        ITestResult calcResult = this.forEngCtrl_.getRecalculateResult();
        this.displayResultMsg(calcResult);
        this.scriptMgr_.setSelectedStep(newScript);
        this.setDisplayStep(newScript);
        this.setFullScript(newScript);
        this.scriptCtrl_.setDbStructureModified(false);
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ScriptViewerTopComponent.getDefault();
        }
    }
}

